/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;

public abstract class StateBackend<Backend extends StateBackend<Backend>>
implements Serializable {
    private static final long serialVersionUID = 4620413814639220247L;

    public abstract void initializeForJob(JobID var1) throws Exception;

    public abstract void disposeAllStateForCurrentJob() throws Exception;

    public abstract void close() throws Exception;

    public abstract <K, V> KvState<K, V, Backend> createKvState(TypeSerializer<K> var1, TypeSerializer<V> var2, V var3) throws Exception;

    public abstract CheckpointStateOutputStream createCheckpointStateOutputStream(long var1, long var3) throws Exception;

    public CheckpointStateOutputView createCheckpointStateOutputView(long checkpointID, long timestamp) throws Exception {
        return new CheckpointStateOutputView(this.createCheckpointStateOutputStream(checkpointID, timestamp));
    }

    public abstract <S extends Serializable> StateHandle<S> checkpointStateSerializable(S var1, long var2, long var4) throws Exception;

    private static final class DataInputViewHandle
    implements StateHandle<DataInputView> {
        private static final long serialVersionUID = 2891559813513532079L;
        private final StreamStateHandle stream;

        private DataInputViewHandle(StreamStateHandle stream) {
            this.stream = stream;
        }

        @Override
        public DataInputView getState(ClassLoader userCodeClassLoader) throws Exception {
            return new DataInputViewStreamWrapper((InputStream)this.stream.getState(userCodeClassLoader));
        }

        @Override
        public void discardState() throws Exception {
            this.stream.discardState();
        }
    }

    public static final class CheckpointStateOutputView
    extends DataOutputViewStreamWrapper {
        private final CheckpointStateOutputStream out;

        public CheckpointStateOutputView(CheckpointStateOutputStream out) {
            super((OutputStream)out);
            this.out = out;
        }

        public StateHandle<DataInputView> closeAndGetHandle() throws IOException {
            return new DataInputViewHandle(this.out.closeAndGetHandle());
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    public static abstract class CheckpointStateOutputStream
    extends OutputStream {
        public abstract StreamStateHandle closeAndGetHandle() throws IOException;
    }
}

