/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.util.HashMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.memory.MemHeapKvState;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.util.DataInputDeserializer;

public class MemoryHeapKvStateSnapshot<K, V>
implements KvStateSnapshot<K, V, MemoryStateBackend> {
    private static final long serialVersionUID = 1L;
    private final String keySerializerClassName;
    private final String valueSerializerClassName;
    private final byte[] data;
    private final int numEntries;

    public MemoryHeapKvStateSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, byte[] data, int numEntries) {
        this.keySerializerClassName = keySerializer.getClass().getName();
        this.valueSerializerClassName = valueSerializer.getClass().getName();
        this.data = data;
        this.numEntries = numEntries;
    }

    public MemHeapKvState<K, V> restoreState(MemoryStateBackend stateBackend, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, V defaultValue, ClassLoader classLoader) throws Exception {
        if (!keySerializer.getClass().getName().equals(this.keySerializerClassName) || !valueSerializer.getClass().getName().equals(this.valueSerializerClassName)) {
            throw new IllegalArgumentException("Cannot restore the state from the snapshot with the given serializers. State (K/V) was serialized with (" + this.valueSerializerClassName + "/" + this.keySerializerClassName + ")");
        }
        HashMap<Object, Object> stateMap = new HashMap<Object, Object>(this.numEntries);
        DataInputDeserializer in = new DataInputDeserializer(this.data, 0, this.data.length);
        for (int i = 0; i < this.numEntries; ++i) {
            Object key = keySerializer.deserialize((DataInputView)in);
            Object value = valueSerializer.deserialize((DataInputView)in);
            stateMap.put(key, value);
        }
        return new MemHeapKvState<K, V>(keySerializer, valueSerializer, defaultValue, stateMap);
    }

    @Override
    public void discardState() {
    }
}

