/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.StringUtils;

public class SerializableHashMap<K extends IOReadableWritable, V extends IOReadableWritable>
extends HashMap<K, V>
implements IOReadableWritable {
    private static final long serialVersionUID = 6693468726881121924L;

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            IOReadableWritable key = (IOReadableWritable)entry.getKey();
            IOReadableWritable value = (IOReadableWritable)entry.getValue();
            StringUtils.writeNullableString((String)key.getClass().getName(), (DataOutputView)out);
            key.write(out);
            StringUtils.writeNullableString((String)value.getClass().getName(), (DataOutputView)out);
            value.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        int numberOfMapEntries = in.readInt();
        for (int i = 0; i < numberOfMapEntries; ++i) {
            IOReadableWritable value;
            Class<?> valueClass;
            Class<?> keyClass;
            String keyType = StringUtils.readNullableString((DataInputView)in);
            try {
                keyClass = Class.forName(keyType);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            IOReadableWritable key = null;
            try {
                key = (IOReadableWritable)keyClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            key.read(in);
            String valueType = StringUtils.readNullableString((DataInputView)in);
            try {
                valueClass = Class.forName(valueType);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            try {
                value = (IOReadableWritable)valueClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            value.read(in);
            this.put(key, value);
        }
    }
}

