/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.slf4j.Logger;
import sun.misc.Signal;

public class SignalHandler {
    private static boolean registered = false;

    public static void register(Logger LOG) {
        if (registered) {
            throw new IllegalStateException("Can't re-install the signal handlers.");
        }
        registered = true;
        StringBuilder bld = new StringBuilder();
        bld.append("registered UNIX signal handlers for [");
        String[] SIGNALS = new String[]{"TERM", "HUP", "INT"};
        String separator = "";
        for (String signalName : SIGNALS) {
            try {
                new Handler(signalName, LOG);
                bld.append(separator);
                bld.append(signalName);
                separator = ", ";
            }
            catch (Exception e) {
                LOG.debug("Error while registering signal handler", e);
            }
        }
        bld.append("]");
        LOG.info(bld.toString());
    }

    private static class Handler
    implements sun.misc.SignalHandler {
        private final Logger LOG;
        private final sun.misc.SignalHandler prevHandler;

        Handler(String name, Logger LOG) {
            this.LOG = LOG;
            this.prevHandler = Signal.handle(new Signal(name), this);
        }

        @Override
        public void handle(Signal signal) {
            this.LOG.error("RECEIVED SIGNAL " + signal.getNumber() + ": SIG" + signal.getName());
            this.prevHandler.handle(signal);
        }
    }
}

