/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.apache.curator.framework.recipes.cache;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.shaded.org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.data.Stat;

public class ChildData
implements Comparable<ChildData> {
    private final String path;
    private final Stat stat;
    private final AtomicReference<byte[]> data;

    public ChildData(String path, Stat stat, byte[] data) {
        this.path = PathUtils.validatePath(path);
        this.stat = stat;
        this.data = new AtomicReference<byte[]>(data);
    }

    @Override
    public int compareTo(ChildData rhs) {
        if (this == rhs) {
            return 0;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return -1;
        }
        return this.path.compareTo(rhs.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildData childData = (ChildData)o;
        if (!Arrays.equals(this.data.get(), childData.data.get())) {
            return false;
        }
        if (this.path != null ? !this.path.equals(childData.path) : childData.path != null) {
            return false;
        }
        return !(this.stat != null ? !this.stat.equals(childData.stat) : childData.stat != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
        result = 31 * result + (this.data != null ? Arrays.hashCode(this.data.get()) : 0);
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public Stat getStat() {
        return this.stat;
    }

    public byte[] getData() {
        return this.data.get();
    }

    void clearData() {
        this.data.set(null);
    }

    public String toString() {
        return "ChildData{path='" + this.path + '\'' + ", stat=" + this.stat + ", data=" + Arrays.toString(this.data.get()) + '}';
    }
}

