/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGroupEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;

public class ExecutionGraphIterator
implements Iterator<ExecutionVertex> {
    private static final Log LOG = LogFactory.getLog(ExecutionGraphIterator.class);
    private final ExecutionGraph executionGraph;
    private final boolean forward;
    private final int startStage;
    private final boolean confinedToStage;
    private int numVisitedEntryVertices = 0;
    private final Stack<TraversalEntry> traversalStack = new Stack();
    private final Set<ExecutionVertex> alreadyVisited = new HashSet<ExecutionVertex>();

    public ExecutionGraphIterator(ExecutionGraph executionGraph, boolean forward) {
        this(executionGraph, forward ? 0 : executionGraph.getNumberOfStages() - 1, false, forward);
    }

    public ExecutionGraphIterator(ExecutionGraph executionGraph, int startStage, boolean confinedToStage, boolean forward) {
        this.executionGraph = executionGraph;
        this.forward = forward;
        this.startStage = startStage;
        this.confinedToStage = confinedToStage;
        if (startStage >= this.executionGraph.getNumberOfStages()) {
            return;
        }
        if (forward) {
            if (executionGraph.getNumberOfInputVertices(startStage) > 0) {
                TraversalEntry te = new TraversalEntry(executionGraph.getInputVertex(startStage, 0), 0, 0);
                this.traversalStack.push(te);
                this.alreadyVisited.add(te.getExecutionVertex());
            }
        } else if (executionGraph.getNumberOfOutputVertices(startStage) > 0) {
            TraversalEntry te = new TraversalEntry(executionGraph.getOutputVertex(startStage, 0), 0, 0);
            this.traversalStack.push(te);
            this.alreadyVisited.add(te.getExecutionVertex());
        }
    }

    public ExecutionGraphIterator(ExecutionGraph executionGraph, ExecutionVertex startVertex, boolean forward) {
        this.executionGraph = executionGraph;
        this.forward = forward;
        this.numVisitedEntryVertices = -1;
        this.startStage = 0;
        this.confinedToStage = false;
        TraversalEntry te = new TraversalEntry(startVertex, 0, 0);
        this.traversalStack.push(te);
        this.alreadyVisited.add(startVertex);
    }

    @Override
    public boolean hasNext() {
        if (this.traversalStack.isEmpty()) {
            if (this.numVisitedEntryVertices < 0) {
                return false;
            }
            ++this.numVisitedEntryVertices;
            if (this.forward ? this.executionGraph.getNumberOfInputVertices(this.startStage) <= this.numVisitedEntryVertices : this.executionGraph.getNumberOfOutputVertices(this.startStage) <= this.numVisitedEntryVertices) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ExecutionVertex next() {
        if (this.traversalStack.isEmpty()) {
            if (this.numVisitedEntryVertices < 0) {
                return null;
            }
            TraversalEntry newentry = this.forward ? new TraversalEntry(this.executionGraph.getInputVertex(this.startStage, this.numVisitedEntryVertices), 0, 0) : new TraversalEntry(this.executionGraph.getOutputVertex(this.startStage, this.numVisitedEntryVertices), 0, 0);
            this.traversalStack.push(newentry);
            this.alreadyVisited.add(newentry.getExecutionVertex());
        }
        ExecutionVertex returnVertex = this.traversalStack.peek().getExecutionVertex();
        do {
            TraversalEntry te;
            ExecutionVertex candidateVertex;
            if ((candidateVertex = this.getCandidateVertex(te = this.traversalStack.peek(), this.forward)) != null) {
                TraversalEntry newte = new TraversalEntry(candidateVertex, 0, 0);
                this.traversalStack.push(newte);
                this.alreadyVisited.add(candidateVertex);
                break;
            }
            this.traversalStack.pop();
        } while (!this.traversalStack.isEmpty());
        return returnVertex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutionVertex getCandidateVertex(TraversalEntry te, boolean forward) {
        if (forward) {
            while (true) {
                if (this.confinedToStage && te.getCurrentChannel() == 0) {
                    while (this.currentGateLeadsToOtherStage(te, this.forward)) {
                        te.increaseCurrentGate();
                    }
                }
                if (te.getCurrentGate() >= te.getExecutionVertex().getNumberOfOutputGates()) return null;
                if (te.getCurrentChannel() >= te.getExecutionVertex().getOutputGate(te.getCurrentGate()).getNumberOfEdges()) {
                    te.increaseCurrentGate();
                    te.resetCurrentChannel();
                    continue;
                }
                ExecutionEdge outputChannel = te.getExecutionVertex().getOutputGate(te.getCurrentGate()).getEdge(te.getCurrentChannel());
                ExecutionVertex tmp = outputChannel.getInputGate().getVertex();
                if (tmp == null) {
                    LOG.error((Object)"Inconsistency in vertex map found (forward)!");
                }
                te.increaseCurrentChannel();
                if (!this.alreadyVisited.contains(tmp)) return tmp;
            }
        }
        while (te.getCurrentGate() < te.getExecutionVertex().getNumberOfInputGates()) {
            if (te.getCurrentChannel() >= te.getExecutionVertex().getInputGate(te.getCurrentGate()).getNumberOfEdges()) {
                te.increaseCurrentGate();
                te.resetCurrentChannel();
                continue;
            }
            ExecutionEdge inputChannel = te.getExecutionVertex().getInputGate(te.getCurrentGate()).getEdge(te.getCurrentChannel());
            ExecutionVertex tmp = inputChannel.getOutputGate().getVertex();
            if (tmp == null) {
                LOG.error((Object)"Inconsistency in vertex map found (backward)!");
            }
            te.increaseCurrentChannel();
            if (this.alreadyVisited.contains(tmp)) continue;
            return tmp;
        }
        return null;
    }

    private boolean currentGateLeadsToOtherStage(TraversalEntry te, boolean forward) {
        ExecutionGroupVertex groupVertex = te.getExecutionVertex().getGroupVertex();
        if (forward) {
            if (te.getCurrentGate() >= groupVertex.getNumberOfForwardLinks()) {
                return false;
            }
            ExecutionGroupEdge edge = groupVertex.getForwardEdge(te.getCurrentGate());
            if (edge.getTargetVertex().getStageNumber() == groupVertex.getStageNumber()) {
                return false;
            }
        } else {
            if (te.getCurrentGate() >= groupVertex.getNumberOfBackwardLinks()) {
                return false;
            }
            ExecutionGroupEdge edge = groupVertex.getBackwardEdge(te.getCurrentGate());
            if (edge.getSourceVertex().getStageNumber() == groupVertex.getStageNumber()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The method remove is not implemented for this type of iterator");
    }

    private static class TraversalEntry {
        private final ExecutionVertex executionVertex;
        private int currentGate;
        private int currentChannel;

        public TraversalEntry(ExecutionVertex executionVertex, int currentGate, int currentChannel) {
            this.executionVertex = executionVertex;
            this.currentGate = currentGate;
            this.currentChannel = currentChannel;
        }

        public ExecutionVertex getExecutionVertex() {
            return this.executionVertex;
        }

        public int getCurrentGate() {
            return this.currentGate;
        }

        public int getCurrentChannel() {
            return this.currentChannel;
        }

        public void increaseCurrentChannel() {
            ++this.currentChannel;
        }

        public void increaseCurrentGate() {
            ++this.currentGate;
        }

        public void resetCurrentChannel() {
            this.currentChannel = 0;
        }
    }
}

