/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public final class ExecutionSignature {
    private static final Log LOG = LogFactory.getLog(ExecutionSignature.class);
    private static final String HASHINGALGORITHM = "SHA-1";
    private static MessageDigest messageDigest = null;
    private final byte[] signature;

    private ExecutionSignature(byte[] signature) {
        this.signature = signature;
    }

    public static synchronized ExecutionSignature createSignature(Class<? extends AbstractInvokable> invokableClass, JobID jobID) {
        Object[] requiredJarFiles;
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance(HASHINGALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)"Unable to load message digest algorithm SHA-1");
                return null;
            }
        }
        messageDigest.reset();
        messageDigest.update(invokableClass.getName().getBytes());
        try {
            requiredJarFiles = LibraryCacheManager.getRequiredJarFiles(jobID);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Cannot access library cache manager for job ID " + jobID));
            return null;
        }
        Arrays.sort(requiredJarFiles);
        for (int i = 0; i < requiredJarFiles.length; ++i) {
            messageDigest.update(((String)requiredJarFiles[i]).getBytes());
        }
        return new ExecutionSignature(messageDigest.digest());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionSignature) {
            ExecutionSignature executionSignature = (ExecutionSignature)obj;
            return Arrays.equals(this.signature, executionSignature.signature);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.signature.length; ++i) {
            hashCode += this.signature[i];
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.signature.length; ++i) {
            stringBuffer.append(Integer.toHexString(0xFF & this.signature[i]));
        }
        return stringBuffer.toString();
    }
}

