/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class HardwareDescription
implements IOReadableWritable {
    private int numberOfCPUCores = 0;
    private long sizeOfPhysicalMemory = 0L;
    private long sizeOfFreeMemory = 0L;

    public HardwareDescription() {
    }

    HardwareDescription(int numberOfCPUCores, long sizeOfPhysicalMemory, long sizeOfFreeMemory) {
        this.numberOfCPUCores = numberOfCPUCores;
        this.sizeOfPhysicalMemory = sizeOfPhysicalMemory;
        this.sizeOfFreeMemory = sizeOfFreeMemory;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.numberOfCPUCores);
        out.writeLong(this.sizeOfPhysicalMemory);
        out.writeLong(this.sizeOfFreeMemory);
    }

    public void read(DataInputView in) throws IOException {
        this.numberOfCPUCores = in.readInt();
        this.sizeOfPhysicalMemory = in.readLong();
        this.sizeOfFreeMemory = in.readLong();
    }

    public int getNumberOfCPUCores() {
        return this.numberOfCPUCores;
    }

    public long getSizeOfPhysicalMemory() {
        return this.sizeOfPhysicalMemory;
    }

    public long getSizeOfFreeMemory() {
        return this.sizeOfFreeMemory;
    }
}

