/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.runtime.io.network.Envelope;

public class OutboundConnectionQueue
extends ChannelInboundHandlerAdapter
implements ChannelFutureListener {
    private static final Log LOG = LogFactory.getLog(OutboundConnectionQueue.class);
    private final Channel channel;
    private final ArrayDeque<Envelope> queuedEnvelopes = new ArrayDeque();
    private final AtomicInteger numQueuedEnvelopes = new AtomicInteger(0);

    public OutboundConnectionQueue(Channel channel) {
        this.channel = channel;
        channel.pipeline().addFirst(new ChannelHandler[]{this});
    }

    public void enqueue(Envelope env) {
        this.channel.pipeline().fireUserEventTriggered((Object)env);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object envelopeToEnqueue) throws Exception {
        boolean triggerWrite = this.queuedEnvelopes.isEmpty();
        this.queuedEnvelopes.addLast((Envelope)envelopeToEnqueue);
        this.numQueuedEnvelopes.incrementAndGet();
        if (triggerWrite) {
            this.writeAndFlushNextEnvelopeIfPossible();
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.writeAndFlushNextEnvelopeIfPossible();
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (future.isSuccess()) {
            this.writeAndFlushNextEnvelopeIfPossible();
        } else if (future.cause() != null) {
            this.exceptionOccurred(future.cause());
        } else {
            this.exceptionOccurred(new Exception("Envelope send aborted."));
        }
    }

    public int getNumQueuedEnvelopes() {
        return this.numQueuedEnvelopes.intValue();
    }

    public String toString() {
        return this.channel.toString();
    }

    private void writeAndFlushNextEnvelopeIfPossible() {
        if (this.channel.isWritable() && !this.queuedEnvelopes.isEmpty()) {
            Envelope nextEnvelope = this.queuedEnvelopes.pollFirst();
            this.numQueuedEnvelopes.decrementAndGet();
            this.channel.writeAndFlush((Object)nextEnvelope).addListener((GenericFutureListener)this);
        }
    }

    private void exceptionOccurred(Throwable t) throws Exception {
        LOG.error((Object)("An exception occurred in Channel " + this.channel + ": " + t.getMessage()));
        throw new Exception(t);
    }
}

