/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.execution.ExecutionListener;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionPipeline;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertexID;
import org.apache.flink.runtime.executiongraph.InternalJobStatus;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobmanager.scheduler.DefaultScheduler;

public class DefaultExecutionListener
implements ExecutionListener {
    private final DefaultScheduler scheduler;
    private final ExecutionVertex executionVertex;

    public DefaultExecutionListener(DefaultScheduler scheduler, ExecutionVertex executionVertex) {
        this.scheduler = scheduler;
        this.executionVertex = executionVertex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executionStateChanged(JobID jobID, ExecutionVertexID vertexID, ExecutionState newExecutionState, String optionalMessage) {
        ExecutionGraph eg = this.executionVertex.getExecutionGraph();
        if (newExecutionState == ExecutionState.FINISHING) {
            ExecutionPipeline pipeline = this.executionVertex.getExecutionPipeline();
            if (!pipeline.isFinishing()) {
                return;
            }
            ExecutionGroupVertex groupVertex = this.executionVertex.getGroupVertex();
            for (int i = 0; i < groupVertex.getCurrentNumberOfGroupMembers(); ++i) {
                ExecutionVertex groupMember = groupVertex.getGroupMember(i);
                if (!groupMember.compareAndUpdateExecutionState(ExecutionState.SCHEDULED, ExecutionState.ASSIGNED)) continue;
                ExecutionPipeline pipelineToBeDeployed = groupMember.getExecutionPipeline();
                pipelineToBeDeployed.setAllocatedResource(this.executionVertex.getAllocatedResource());
                pipelineToBeDeployed.updateExecutionState(ExecutionState.ASSIGNED);
                this.scheduler.deployAssignedPipeline(pipelineToBeDeployed);
                return;
            }
        }
        if (newExecutionState == ExecutionState.CANCELED || newExecutionState == ExecutionState.FINISHED) {
            ExecutionGraph executionGraph = eg;
            synchronized (executionGraph) {
                if (this.scheduler.getVerticesToBeRestarted().remove(this.executionVertex.getID()) != null) {
                    if (eg.getJobStatus() == InternalJobStatus.FAILING) {
                        return;
                    }
                    this.executionVertex.updateExecutionState(ExecutionState.ASSIGNED, "Restart as part of recovery");
                    this.scheduler.deployAssignedVertices(this.executionVertex);
                    return;
                }
            }
        }
        if (newExecutionState == ExecutionState.FINISHED || newExecutionState == ExecutionState.CANCELED || newExecutionState == ExecutionState.FAILED) {
            this.scheduler.checkAndReleaseAllocatedResource(eg, this.executionVertex.getAllocatedResource());
        }
    }

    @Override
    public void userThreadFinished(JobID jobID, ExecutionVertexID vertexID, Thread userThread) {
    }

    @Override
    public void userThreadStarted(JobID jobID, ExecutionVertexID vertexID, Thread userThread) {
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

