/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.splitassigner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphIterator;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertex;
import org.apache.flink.runtime.executiongraph.ExecutionGroupVertexIterator;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertexID;

final class InputSplitTracker {
    private static final Log LOG = LogFactory.getLog(InputSplitTracker.class);
    private final ConcurrentMap<ExecutionVertexID, List<InputSplit>> splitMap = new ConcurrentHashMap<ExecutionVertexID, List<InputSplit>>();

    InputSplitTracker() {
    }

    void registerJob(ExecutionGraph eg) {
        ExecutionGroupVertexIterator it = new ExecutionGroupVertexIterator(eg, true, -1);
        while (it.hasNext()) {
            ExecutionGroupVertex groupVertex = (ExecutionGroupVertex)it.next();
            InputSplit[] inputSplits = groupVertex.getInputSplits();
            if (inputSplits == null || inputSplits.length == 0) continue;
            for (int i = 0; i < groupVertex.getCurrentNumberOfGroupMembers(); ++i) {
                ExecutionVertex vertex = groupVertex.getGroupMember(i);
                if (this.splitMap.put(vertex.getID(), new ArrayList()) == null) continue;
                LOG.error((Object)("InputSplitTracker must keep track of two vertices with ID " + vertex.getID()));
            }
        }
    }

    void unregisterJob(ExecutionGraph eg) {
        ExecutionGraphIterator it = new ExecutionGraphIterator(eg, true);
        while (it.hasNext()) {
            this.splitMap.remove(((ExecutionVertex)it.next()).getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputSplit getInputSplitFromLog(ExecutionVertex vertex, int sequenceNumber) {
        List inputSplitLog = (List)this.splitMap.get(vertex.getID());
        if (inputSplitLog == null) {
            LOG.error((Object)("Cannot find input split log for vertex " + vertex + " (" + vertex.getID() + ")"));
            return null;
        }
        List list = inputSplitLog;
        synchronized (list) {
            if (sequenceNumber < inputSplitLog.size()) {
                return (InputSplit)inputSplitLog.get(sequenceNumber);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputSplitToLog(ExecutionVertex vertex, int sequenceNumber, InputSplit inputSplit) {
        List inputSplitLog = (List)this.splitMap.get(vertex.getID());
        if (inputSplitLog == null) {
            LOG.error((Object)("Cannot find input split log for vertex " + vertex + " (" + vertex.getID() + ")"));
            return;
        }
        List list = inputSplitLog;
        synchronized (list) {
            if (inputSplitLog.size() != sequenceNumber) {
                LOG.error((Object)("Expected input split with sequence number " + inputSplitLog.size() + " for vertex " + vertex + " (" + vertex.getID() + ") but received " + sequenceNumber + ", skipping..."));
                return;
            }
            inputSplitLog.add(inputSplit);
        }
    }
}

