/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MenuServlet
extends HttpServlet {
    private static final long serialVersionUID = 117543213991787547L;
    private static final Log LOG = LogFactory.getLog(MenuServlet.class);
    private static final String[] entries = new String[]{"index", "history", "configuration", "taskmanagers"};
    private static final String[] names = new String[]{"Dashboard", "History", "Configuration", "Task Managers"};
    private static final String[] classes = new String[]{"fa fa-dashboard", "fa fa-bar-chart-o", "fa fa-keyboard-o", "fa fa-building-o"};

    public MenuServlet() {
        if (names.length != entries.length || names.length != classes.length) {
            LOG.fatal((Object)"The Arrays 'entries', 'classes' and 'names' differ in thier length. This is not allowed!");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.setContentType("application/json");
        if ("index".equals(req.getParameter("get"))) {
            this.writeMenu("index", resp);
        } else if ("analyze".equals(req.getParameter("get"))) {
            this.writeMenu("analyze", resp);
        } else if ("history".equals(req.getParameter("get"))) {
            this.writeMenu("history", resp);
        } else if ("configuration".equals(req.getParameter("get"))) {
            this.writeMenu("configuration", resp);
        } else if ("taskmanagers".equals(req.getParameter("get"))) {
            this.writeMenu("taskmanagers", resp);
        }
    }

    private void writeMenu(String me, HttpServletResponse resp) throws IOException {
        String r = "";
        for (int i = 0; i < entries.length; ++i) {
            r = entries[i].equals(me) ? r + this.writeLine(3, "<li class='active'><a href='" + entries[i] + ".html'><i class='" + classes[i] + "'></i> " + names[i] + "</a></li>") : r + this.writeLine(3, "<li><a href='" + entries[i] + ".html'><i class='" + classes[i] + "'></i> " + names[i] + "</a></li>");
        }
        resp.getWriter().write(r);
    }

    private String writeLine(int tab, String line) {
        String s = "";
        for (int i = 0; i < tab; ++i) {
            s = s + "\t";
        }
        s = s + " " + line + " \n";
        return s;
    }
}

