/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.managementgraph;

import org.apache.flink.runtime.io.network.channels.ChannelType;
import org.apache.flink.runtime.managementgraph.ManagementAttachment;
import org.apache.flink.runtime.managementgraph.ManagementEdgeID;
import org.apache.flink.runtime.managementgraph.ManagementGate;

public final class ManagementEdge
extends ManagementAttachment {
    private final ManagementGate source;
    private final ManagementGate target;
    private final int sourceIndex;
    private final int targetIndex;
    private final ChannelType channelType;
    private final ManagementEdgeID sourceEdgeID;
    private final ManagementEdgeID targetEdgeID;

    public ManagementEdge(ManagementEdgeID sourceEdgeID, ManagementEdgeID targetEdgeID, ManagementGate source, int sourceIndex, ManagementGate target, int targetIndex, ChannelType channelType) {
        this.sourceEdgeID = sourceEdgeID;
        this.targetEdgeID = targetEdgeID;
        this.source = source;
        this.target = target;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.channelType = channelType;
        this.source.insertForwardEdge(this, sourceIndex);
        this.target.insertBackwardEdge(this, targetIndex);
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public ManagementGate getSource() {
        return this.source;
    }

    public ManagementGate getTarget() {
        return this.target;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public ManagementEdgeID getSourceEdgeID() {
        return this.sourceEdgeID;
    }

    public ManagementEdgeID getTargetEdgeID() {
        return this.targetEdgeID;
    }
}

