/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.managementgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.managementgraph.ManagementAttachment;
import org.apache.flink.runtime.managementgraph.ManagementGate;
import org.apache.flink.runtime.managementgraph.ManagementGateID;
import org.apache.flink.runtime.managementgraph.ManagementGraph;
import org.apache.flink.runtime.managementgraph.ManagementGroupVertex;
import org.apache.flink.runtime.managementgraph.ManagementVertexID;
import org.apache.flink.runtime.util.EnumUtils;
import org.apache.flink.util.StringUtils;

public final class ManagementVertex
extends ManagementAttachment
implements IOReadableWritable {
    private final ManagementGroupVertex groupVertex;
    private final ManagementVertexID id;
    private final List<ManagementGate> inputGates = new ArrayList<ManagementGate>();
    private final List<ManagementGate> outputGates = new ArrayList<ManagementGate>();
    private ExecutionState executionState = ExecutionState.CREATED;
    private String instanceName;
    private final int indexInGroup;
    private String optMessage;

    public ManagementVertex(ManagementGroupVertex groupVertex, ManagementVertexID id, String instanceName, int indexInGroup) {
        this.groupVertex = groupVertex;
        this.id = id;
        this.instanceName = instanceName;
        this.indexInGroup = indexInGroup;
        groupVertex.addGroupMember(this);
    }

    void addGate(ManagementGate gate) {
        if (gate.isInputGate()) {
            this.inputGates.add(gate);
        } else {
            this.outputGates.add(gate);
        }
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getNumberOfInputGates() {
        return this.inputGates.size();
    }

    public int getNumberOfOutputGates() {
        return this.outputGates.size();
    }

    public ManagementGate getInputGate(int index) {
        if (index < this.inputGates.size()) {
            return this.inputGates.get(index);
        }
        return null;
    }

    public ManagementGate getOutputGate(int index) {
        if (index < this.outputGates.size()) {
            return this.outputGates.get(index);
        }
        return null;
    }

    public ManagementGroupVertex getGroupVertex() {
        return this.groupVertex;
    }

    public ManagementGraph getGraph() {
        return this.groupVertex.getGraph();
    }

    public ManagementVertexID getID() {
        return this.id;
    }

    public String getName() {
        return this.groupVertex.getName();
    }

    public int getNumberOfVerticesInGroup() {
        return this.groupVertex.getNumberOfGroupMembers();
    }

    public int getIndexInGroup() {
        return this.indexInGroup;
    }

    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setOptMessage(String optMessage) {
        this.optMessage = optMessage;
    }

    public String getOptMessage() {
        return this.optMessage;
    }

    public void read(DataInputView in) throws IOException {
        this.executionState = EnumUtils.readEnum((DataInput)in, ExecutionState.class);
        int numberOfInputGates = in.readInt();
        for (int i = 0; i < numberOfInputGates; ++i) {
            new ManagementGate(this, new ManagementGateID(), i, true);
        }
        int numberOfOutputGates = in.readInt();
        for (int i = 0; i < numberOfOutputGates; ++i) {
            new ManagementGate(this, new ManagementGateID(), i, false);
        }
        this.instanceName = StringRecord.readString((DataInput)in);
    }

    public void write(DataOutputView out) throws IOException {
        EnumUtils.writeEnum((DataOutput)out, this.executionState);
        out.writeInt(this.inputGates.size());
        out.writeInt(this.outputGates.size());
        StringRecord.writeString((DataOutput)out, (String)this.instanceName);
    }

    public String toString() {
        return String.format("%s_%d", this.getGroupVertex().getName(), this.indexInGroup);
    }

    public String toJson() {
        StringBuilder json = new StringBuilder("");
        json.append("{");
        json.append("\"vertexid\": \"" + this.getID() + "\",");
        json.append("\"vertexname\": \"" + StringUtils.escapeHtml((String)this.toString()) + "\",");
        json.append("\"vertexstatus\": \"" + (Object)((Object)this.getExecutionState()) + "\",");
        json.append("\"vertexinstancename\": \"" + this.getInstanceName() + "\"");
        json.append("}");
        return json.toString();
    }
}

