/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class ReduceDriver<T>
implements PactDriver<ReduceFunction<T>, T> {
    private static final Log LOG = LogFactory.getLog(ReduceDriver.class);
    private PactTaskContext<ReduceFunction<T>, T> taskContext;
    private MutableObjectIterator<T> input;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private volatile boolean running;

    @Override
    public void setup(PactTaskContext<ReduceFunction<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<ReduceFunction<T>> getStubType() {
        Class<ReduceFunction> clazz = ReduceFunction.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.SORTED_REDUCE) {
            throw new Exception("Unrecognized driver strategy for Reduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.comparator = this.taskContext.getInputComparator(0);
        this.input = this.taskContext.getInput(0);
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("Reducer preprocessing done. Running Reducer code."));
        }
        MutableObjectIterator<T> input = this.input;
        TypeSerializer<T> serializer = this.serializer;
        TypeComparator<T> comparator = this.comparator;
        ReduceFunction<T> function = this.taskContext.getStub();
        Collector<T> output = this.taskContext.getOutputCollector();
        Object value = input.next(serializer.createInstance());
        while (this.running && value != null) {
            comparator.setReference(value);
            Object res = value;
            while ((value = input.next(serializer.createInstance())) != null && comparator.equalToReference(value)) {
                res = function.reduce(res, value);
            }
            output.collect(res);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

