/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.impl;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.profiling.impl.types.InternalExecutionVertexThreadProfilingData;

public class EnvironmentThreadSet {
    private static final long NANO_TO_MILLISECONDS = 1000000L;
    private static final long PERCENT = 100L;
    private final Thread mainThread;
    private final ExecutionVertexID executionVertexID;
    private final Map<Thread, CPUUtilizationSnapshot> userThreads = new HashMap<Thread, CPUUtilizationSnapshot>();
    private CPUUtilizationSnapshot mainThreadSnapshot = null;

    public EnvironmentThreadSet(ThreadMXBean tmx, Thread mainThread, ExecutionVertexID executionVertexID) {
        this.mainThread = mainThread;
        this.executionVertexID = executionVertexID;
        this.mainThreadSnapshot = this.createCPUUtilizationSnapshot(tmx, mainThread, System.currentTimeMillis());
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserThread(ThreadMXBean tmx, Thread thread) {
        Map<Thread, CPUUtilizationSnapshot> map = this.userThreads;
        synchronized (map) {
            this.userThreads.put(thread, this.createCPUUtilizationSnapshot(tmx, thread, System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserThread(Thread thread) {
        Map<Thread, CPUUtilizationSnapshot> map = this.userThreads;
        synchronized (map) {
            this.userThreads.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfUserThreads() {
        Map<Thread, CPUUtilizationSnapshot> map = this.userThreads;
        synchronized (map) {
            return this.userThreads.size();
        }
    }

    private CPUUtilizationSnapshot createCPUUtilizationSnapshot(ThreadMXBean tmx, Thread thread, long timestamp) {
        long threadId = thread.getId();
        ThreadInfo threadInfo = tmx.getThreadInfo(threadId);
        if (threadInfo == null) {
            return null;
        }
        return new CPUUtilizationSnapshot(timestamp, tmx.getThreadCpuTime(threadId) / 1000000L, tmx.getThreadUserTime(threadId) / 1000000L, threadInfo.getWaitedTime(), threadInfo.getBlockedTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalExecutionVertexThreadProfilingData captureCPUUtilization(JobID jobID, ThreadMXBean tmx, long timestamp) {
        Map<Thread, CPUUtilizationSnapshot> map = this.userThreads;
        synchronized (map) {
            CPUUtilizationSnapshot newMainThreadSnapshot = this.createCPUUtilizationSnapshot(tmx, this.mainThread, timestamp);
            if (newMainThreadSnapshot == null) {
                return null;
            }
            long mainInterval = newMainThreadSnapshot.getTimestamp() - this.mainThreadSnapshot.getTimestamp();
            if (mainInterval == 0L) {
                return null;
            }
            long cputime = newMainThreadSnapshot.getTotalCPUTime() - this.mainThreadSnapshot.getTotalCPUTime();
            long usrtime = newMainThreadSnapshot.getTotalCPUUserTime() - this.mainThreadSnapshot.getTotalCPUUserTime();
            long systime = cputime - usrtime;
            long waitime = newMainThreadSnapshot.getTotalCPUWaitTime() - this.mainThreadSnapshot.getTotalCPUWaitTime();
            long blktime = newMainThreadSnapshot.getTotalCPUBlockTime() - this.mainThreadSnapshot.getTotalCPUBlockTime();
            int sumUsrTime = (int)(usrtime * 100L / mainInterval);
            int sumSysTime = (int)(systime * 100L / mainInterval);
            int sumBlkTime = (int)(blktime * 100L / mainInterval);
            int sumWaiTime = (int)(waitime * 100L / mainInterval);
            this.mainThreadSnapshot = newMainThreadSnapshot;
            if (!this.userThreads.isEmpty()) {
                Iterator<Thread> it = this.userThreads.keySet().iterator();
                int divisor = this.userThreads.size();
                while (it.hasNext()) {
                    Thread userThread = it.next();
                    CPUUtilizationSnapshot newUtilizationSnaphot = this.createCPUUtilizationSnapshot(tmx, userThread, timestamp);
                    CPUUtilizationSnapshot oldUtilizationSnapshot = this.userThreads.get(userThread);
                    long interval = newUtilizationSnaphot.getTimestamp() - oldUtilizationSnapshot.getTimestamp();
                    if (interval == 0L) {
                        --divisor;
                        continue;
                    }
                    cputime = newUtilizationSnaphot.getTotalCPUTime() - oldUtilizationSnapshot.getTotalCPUTime();
                    usrtime = newUtilizationSnaphot.getTotalCPUUserTime() - oldUtilizationSnapshot.getTotalCPUUserTime();
                    systime = cputime - usrtime;
                    waitime = newUtilizationSnaphot.getTotalCPUWaitTime() - oldUtilizationSnapshot.getTotalCPUWaitTime();
                    blktime = newUtilizationSnaphot.getTotalCPUBlockTime() - oldUtilizationSnapshot.getTotalCPUBlockTime();
                    sumUsrTime += (int)(usrtime * 100L / interval);
                    sumSysTime += (int)(systime * 100L / interval);
                    sumBlkTime += (int)(blktime * 100L / interval);
                    sumWaiTime += (int)(waitime * 100L / interval);
                    this.userThreads.put(userThread, newUtilizationSnaphot);
                }
                sumUsrTime /= divisor + 1;
                sumSysTime /= divisor + 1;
                sumBlkTime /= divisor + 1;
                sumWaiTime /= divisor + 1;
            }
            return new InternalExecutionVertexThreadProfilingData(jobID, this.executionVertexID, (int)mainInterval, sumUsrTime, sumSysTime, sumBlkTime, sumWaiTime);
        }
    }

    private class CPUUtilizationSnapshot {
        private final long timestamp;
        private final long totalCPUTime;
        private final long totalCPUUserTime;
        private final long totalCPUWaitTime;
        private final long totalCPUBlockTime;

        public CPUUtilizationSnapshot(long timestamp, long totalCPUTime, long totalCPUUserTime, long totalCPUWaitTime, long totalCPUBlockTime) {
            this.timestamp = timestamp;
            this.totalCPUTime = totalCPUTime;
            this.totalCPUUserTime = totalCPUUserTime;
            this.totalCPUWaitTime = totalCPUWaitTime;
            this.totalCPUBlockTime = totalCPUBlockTime;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getTotalCPUTime() {
            return this.totalCPUTime;
        }

        public long getTotalCPUUserTime() {
            return this.totalCPUUserTime;
        }

        public long getTotalCPUWaitTime() {
            return this.totalCPUWaitTime;
        }

        public long getTotalCPUBlockTime() {
            return this.totalCPUBlockTime;
        }
    }
}

