/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.managementgraph.ManagementVertexID;
import org.apache.flink.runtime.profiling.types.VertexProfilingEvent;

public final class OutputGateProfilingEvent
extends VertexProfilingEvent {
    private int gateIndex;
    private int channelCapacityExhausted;

    public OutputGateProfilingEvent(int gateIndex, int channelCapacityExhausted, ManagementVertexID vertexID, int profilingInterval, JobID jobID, long timestamp, long profilingTimestamp) {
        super(vertexID, profilingInterval, jobID, timestamp, profilingTimestamp);
        this.gateIndex = gateIndex;
        this.channelCapacityExhausted = channelCapacityExhausted;
    }

    public OutputGateProfilingEvent() {
    }

    public int getGateIndex() {
        return this.gateIndex;
    }

    public int getChannelCapacityExhausted() {
        return this.channelCapacityExhausted;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.gateIndex = in.readInt();
        this.channelCapacityExhausted = in.readInt();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.gateIndex);
        out.writeInt(this.channelCapacityExhausted);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OutputGateProfilingEvent)) {
            return false;
        }
        OutputGateProfilingEvent outputGateProfilingEvent = (OutputGateProfilingEvent)obj;
        if (this.gateIndex != outputGateProfilingEvent.getGateIndex()) {
            return false;
        }
        return this.channelCapacityExhausted == outputGateProfilingEvent.getChannelCapacityExhausted();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

