/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.topology;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.topology.NetworkTopology;

public class NetworkNode
implements IOReadableWritable {
    private final NetworkTopology networkTopology;
    private String name = null;
    private final NetworkNode parentNode;
    private final List<NetworkNode> childNodes = new ArrayList<NetworkNode>();

    protected NetworkNode(String name, NetworkNode parentNode, NetworkTopology networkTopology) {
        this.name = name;
        this.parentNode = parentNode;
        this.networkTopology = networkTopology;
        if (this.parentNode != null) {
            this.parentNode.addChild(this);
        }
        if (this.networkTopology != null) {
            this.networkTopology.addNode(this);
        }
    }

    NetworkNode(NetworkNode parentNode, NetworkTopology networkTopology) {
        this.parentNode = parentNode;
        this.networkTopology = networkTopology;
    }

    private void addChild(NetworkNode child) {
        this.childNodes.add(child);
    }

    public void remove() {
        if (!this.isLeafNode()) {
            return;
        }
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        if (this.networkTopology != null) {
            this.networkTopology.removeNode(this);
        }
    }

    private void removeChild(NetworkNode child) {
        this.childNodes.remove(child);
    }

    public boolean isRootNode() {
        return this.parentNode == null;
    }

    public boolean isLeafNode() {
        return this.childNodes.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        if (this.isRootNode()) {
            return 1;
        }
        return 1 + this.parentNode.getDepth();
    }

    public int getHeight() {
        int maxHeight = 0;
        Iterator<NetworkNode> it = this.childNodes.iterator();
        while (it.hasNext()) {
            int height = it.next().getHeight();
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        return 1 + maxHeight;
    }

    public int getNumberOfChildNodes() {
        return this.childNodes.size();
    }

    public NetworkNode getChildNode(int index) {
        if (index < this.childNodes.size()) {
            return this.childNodes.get(index);
        }
        return null;
    }

    public NetworkNode getParentNode() {
        return this.parentNode;
    }

    public NetworkTopology getNetworkTopology() {
        return this.networkTopology;
    }

    public int getDistance(NetworkNode networkNode) {
        int steps = 0;
        NetworkNode tmp = this;
        while (tmp != null) {
            int distance = tmp.isPredecessorOrSelfOf(networkNode);
            if (distance >= 0) {
                return steps + distance;
            }
            tmp = tmp.getParentNode();
            ++steps;
        }
        return Integer.MAX_VALUE;
    }

    private int isPredecessorOrSelfOf(NetworkNode networkNode) {
        NetworkNode tmp = networkNode;
        int steps = 0;
        while (tmp != null) {
            if (this.equals(tmp)) {
                return steps;
            }
            tmp = tmp.getParentNode();
            ++steps;
        }
        return -1;
    }

    public int getDistance(String nodeName) {
        NetworkNode networkNode = this.networkTopology.getNodeByName(nodeName);
        if (networkNode == null) {
            return Integer.MAX_VALUE;
        }
        if (this.equals(networkNode)) {
            return 0;
        }
        return this.getDistance(networkNode);
    }

    public void read(DataInputView in) throws IOException {
        this.name = StringRecord.readString((DataInput)in);
        if (this.networkTopology != null) {
            this.networkTopology.addNode(this);
        }
        int numberOfChildNodes = in.readInt();
        for (int i = 0; i < numberOfChildNodes; ++i) {
            NetworkNode networkNode = new NetworkNode(this, this.networkTopology);
            networkNode.read(in);
            this.childNodes.add(networkNode);
        }
    }

    public void write(DataOutputView out) throws IOException {
        StringRecord.writeString((DataOutput)out, (String)this.name);
        out.writeInt(this.childNodes.size());
        Iterator<NetworkNode> it = this.childNodes.iterator();
        while (it.hasNext()) {
            it.next().write(out);
        }
    }

    public String toString() {
        String str;
        if (this.childNodes.isEmpty()) {
            str = this.name;
        } else {
            Iterator<NetworkNode> it = this.childNodes.iterator();
            StringBuffer buf = new StringBuffer("[");
            while (it.hasNext()) {
                buf.append(it.next().toString());
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("]");
            str = buf.toString();
        }
        return str;
    }
}

