/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.StringUtils;

public class SerializableHashSet<T extends IOReadableWritable>
extends HashSet<T>
implements IOReadableWritable {
    private static final long serialVersionUID = -4615823301768215807L;

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.size());
        for (IOReadableWritable entry : this) {
            StringRecord.writeString((DataOutput)out, (String)entry.getClass().getName());
            entry.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        int numberOfMapEntries = in.readInt();
        for (int i = 0; i < numberOfMapEntries; ++i) {
            String type = StringRecord.readString((DataInput)in);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            IOReadableWritable entry = null;
            try {
                entry = (IOReadableWritable)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            entry.read(in);
            this.add(entry);
        }
    }
}

