/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class BlobKey
implements IOReadableWritable,
Comparable<BlobKey> {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private static final int SIZE = 20;
    private final byte[] key;

    public BlobKey() {
        this.key = new byte[20];
    }

    BlobKey(byte[] key) {
        if (key.length != 20) {
            throw new IllegalArgumentException("BLOB key must have a size of 20 bytes");
        }
        this.key = key;
    }

    public void write(DataOutputView out) throws IOException {
        out.write(this.key);
    }

    public void read(DataInputView in) throws IOException {
        in.readFully(this.key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlobKey)) {
            return false;
        }
        BlobKey bk = (BlobKey)obj;
        return Arrays.equals(this.key, bk.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        char[] hexChars = new char[40];
        for (int i = 0; i < 20; ++i) {
            int v = this.key[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static BlobKey readFromInputStream(InputStream inputStream) throws IOException {
        int read;
        byte[] key = new byte[20];
        for (int bytesRead = 0; bytesRead < 20; bytesRead += read) {
            read = inputStream.read(key, bytesRead, 20 - bytesRead);
            if (read >= 0) continue;
            throw new EOFException();
        }
        return new BlobKey(key);
    }

    void writeToOutputStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.key);
    }

    @Override
    public int compareTo(BlobKey o) {
        byte[] aarr = this.key;
        byte[] barr = o.key;
        int len = Math.min(aarr.length, barr.length);
        for (int i = 0; i < len; ++i) {
            int a = aarr[i] & 0xFF;
            int b = barr[i] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return aarr.length - barr.length;
    }

    public void addToMessageDigest(MessageDigest md) {
        md.update(this.key);
    }
}

