/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.deployment.GateDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.types.StringValue;

public final class TaskDeploymentDescriptor
implements IOReadableWritable {
    private final JobID jobID;
    private final JobVertexID vertexID;
    private final ExecutionAttemptID executionId;
    private String taskName;
    private int indexInSubtaskGroup;
    private int currentNumberOfSubtasks;
    private Configuration jobConfiguration;
    private Configuration taskConfiguration;
    private String invokableClassName;
    private List<GateDeploymentDescriptor> outputGates;
    private List<GateDeploymentDescriptor> inputGates;
    private int targetSlotNumber;
    private final List<BlobKey> requiredJarFiles;

    public TaskDeploymentDescriptor(JobID jobID, JobVertexID vertexID, ExecutionAttemptID execuionId, String taskName, int indexInSubtaskGroup, int currentNumberOfSubtasks, Configuration jobConfiguration, Configuration taskConfiguration, String invokableClassName, List<GateDeploymentDescriptor> outputGates, List<GateDeploymentDescriptor> inputGates, List<BlobKey> requiredJarFiles, int targetSlotNumber) {
        if (jobID == null || vertexID == null || execuionId == null || taskName == null || indexInSubtaskGroup < 0 || currentNumberOfSubtasks <= indexInSubtaskGroup || jobConfiguration == null || taskConfiguration == null || invokableClassName == null || outputGates == null || inputGates == null) {
            throw new IllegalArgumentException();
        }
        if (requiredJarFiles == null) {
            throw new IllegalArgumentException("Argument requiredJarFiles must not be null");
        }
        this.jobID = jobID;
        this.vertexID = vertexID;
        this.executionId = execuionId;
        this.taskName = taskName;
        this.indexInSubtaskGroup = indexInSubtaskGroup;
        this.currentNumberOfSubtasks = currentNumberOfSubtasks;
        this.jobConfiguration = jobConfiguration;
        this.taskConfiguration = taskConfiguration;
        this.invokableClassName = invokableClassName;
        this.outputGates = outputGates;
        this.inputGates = inputGates;
        this.requiredJarFiles = requiredJarFiles;
        this.targetSlotNumber = targetSlotNumber;
    }

    public TaskDeploymentDescriptor() {
        this.jobID = new JobID();
        this.vertexID = new JobVertexID();
        this.executionId = new ExecutionAttemptID();
        this.jobConfiguration = new Configuration();
        this.taskConfiguration = new Configuration();
        this.outputGates = Collections.emptyList();
        this.inputGates = Collections.emptyList();
        this.requiredJarFiles = new ArrayList<BlobKey>();
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public JobVertexID getVertexID() {
        return this.vertexID;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getIndexInSubtaskGroup() {
        return this.indexInSubtaskGroup;
    }

    public int getCurrentNumberOfSubtasks() {
        return this.currentNumberOfSubtasks;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public String getInvokableClassName() {
        return this.invokableClassName;
    }

    public List<GateDeploymentDescriptor> getOutputGates() {
        return this.outputGates;
    }

    public List<GateDeploymentDescriptor> getInputGates() {
        return this.inputGates;
    }

    public List<BlobKey> getRequiredJarFiles() {
        return this.requiredJarFiles;
    }

    public void write(DataOutputView out) throws IOException {
        this.jobID.write(out);
        this.vertexID.write(out);
        this.executionId.write(out);
        StringValue.writeString((CharSequence)this.taskName, (DataOutput)out);
        StringValue.writeString((CharSequence)this.invokableClassName, (DataOutput)out);
        out.writeInt(this.indexInSubtaskGroup);
        out.writeInt(this.currentNumberOfSubtasks);
        out.writeInt(this.targetSlotNumber);
        this.jobConfiguration.write(out);
        this.taskConfiguration.write(out);
        TaskDeploymentDescriptor.writeGateList(this.inputGates, out);
        TaskDeploymentDescriptor.writeGateList(this.outputGates, out);
        out.writeInt(this.requiredJarFiles.size());
        Iterator<BlobKey> it = this.requiredJarFiles.iterator();
        while (it.hasNext()) {
            it.next().write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.jobID.read(in);
        this.vertexID.read(in);
        this.executionId.read(in);
        this.taskName = StringValue.readString((DataInput)in);
        this.invokableClassName = StringValue.readString((DataInput)in);
        this.indexInSubtaskGroup = in.readInt();
        this.currentNumberOfSubtasks = in.readInt();
        this.targetSlotNumber = in.readInt();
        this.jobConfiguration.read(in);
        this.taskConfiguration.read(in);
        this.inputGates = TaskDeploymentDescriptor.readGateList(in);
        this.outputGates = TaskDeploymentDescriptor.readGateList(in);
        int numberOfJarFiles = in.readInt();
        for (int i = 0; i < numberOfJarFiles; ++i) {
            BlobKey key = new BlobKey();
            key.read(in);
            this.requiredJarFiles.add(key);
        }
    }

    private static final void writeGateList(List<GateDeploymentDescriptor> list, DataOutputView out) throws IOException {
        out.writeInt(list.size());
        for (GateDeploymentDescriptor gdd : list) {
            gdd.write(out);
        }
    }

    private static final List<GateDeploymentDescriptor> readGateList(DataInputView in) throws IOException {
        int len = in.readInt();
        ArrayList<GateDeploymentDescriptor> list = new ArrayList<GateDeploymentDescriptor>(len);
        for (int i = 0; i < len; ++i) {
            GateDeploymentDescriptor gdd = new GateDeploymentDescriptor();
            gdd.read(in);
            list.add(gdd);
        }
        return list;
    }
}

