/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.job;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.ManagementEvent;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.StringUtils;

public final class RecentJobEvent
extends AbstractEvent
implements ManagementEvent {
    private static final long serialVersionUID = -3361778351490181333L;
    private JobID jobID;
    private String jobName;
    private JobStatus jobStatus;
    private boolean isProfilingEnabled;
    private long submissionTimestamp;

    public RecentJobEvent(JobID jobID, String jobName, JobStatus jobStatus, boolean isProfilingEnabled, long submissionTimestamp, long timestamp) {
        super(timestamp);
        Preconditions.checkNotNull((Object)jobID);
        Preconditions.checkNotNull((Object)((Object)jobStatus));
        this.jobID = jobID;
        this.jobName = jobName;
        this.jobStatus = jobStatus;
        this.isProfilingEnabled = isProfilingEnabled;
        this.submissionTimestamp = submissionTimestamp;
    }

    public RecentJobEvent() {
        this.jobID = new JobID();
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean isProfilingAvailable() {
        return this.isProfilingEnabled;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public long getSubmissionTimestamp() {
        return this.submissionTimestamp;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.jobID.read(in);
        this.jobName = StringUtils.readNullableString((DataInputView)in);
        this.jobStatus = JobStatus.values()[in.readInt()];
        this.isProfilingEnabled = in.readBoolean();
        this.submissionTimestamp = in.readLong();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.jobID.write(out);
        StringUtils.writeNullableString((String)this.jobName, (DataOutputView)out);
        out.writeInt(this.jobStatus.ordinal());
        out.writeBoolean(this.isProfilingEnabled);
        out.writeLong(this.submissionTimestamp);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RecentJobEvent) {
            RecentJobEvent other = (RecentJobEvent)obj;
            return super.equals(other) && this.jobID.equals(other.jobID) && this.isProfilingEnabled == other.isProfilingEnabled && this.submissionTimestamp == other.submissionTimestamp && (this.jobName == null ? other.jobName == null : other.jobName != null && this.jobName.equals(other.jobName));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.jobID.hashCode() ^ this.jobStatus.ordinal();
    }

    @Override
    public String toString() {
        return String.format("RecentJobEvent #%d at %s - jobId=%s, jobName=%s, status=%s, jobSubmission=%s, profiling=%s", new Object[]{this.getSequenceNumber(), this.getTimestampString(), this.jobID, this.jobName, this.jobStatus, RecentJobEvent.timestampToString(this.submissionTimestamp), this.isProfilingEnabled});
    }
}

