/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hardware {
    private static final Logger LOG = LoggerFactory.getLogger(Hardware.class);
    private static final String LINUX_MEMORY_INFO_PATH = "/proc/meminfo";
    private static final Pattern LINUX_MEMORY_REGEX = Pattern.compile("^MemTotal:\\s*(\\d+)\\s+kB$");

    public static int getNumberCPUCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getSizeOfPhysicalMemory() {
        switch (OperatingSystem.getCurrentOperatingSystem()) {
            case LINUX: {
                return Hardware.getSizeOfPhysicalMemoryForLinux();
            }
            case WINDOWS: {
                return Hardware.getSizeOfPhysicalMemoryForWindows();
            }
            case MAC_OS: {
                return Hardware.getSizeOfPhysicalMemoryForMac();
            }
            case FREE_BSD: {
                return Hardware.getSizeOfPhysicalMemoryForFreeBSD();
            }
            case UNKNOWN: {
                LOG.error("Cannot determine size of physical memory for unknown operating system");
                return -1L;
            }
        }
        LOG.error("Unrecognized OS: " + OperatingSystem.getCurrentOperatingSystem());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getSizeOfPhysicalMemoryForLinux() {
        long l;
        BufferedReader lineReader = null;
        try {
            lineReader = new BufferedReader(new FileReader(LINUX_MEMORY_INFO_PATH));
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                Matcher matcher = LINUX_MEMORY_REGEX.matcher(line);
                if (!matcher.matches()) continue;
                String totalMemory = matcher.group(1);
                long l2 = Long.parseLong(totalMemory) * 1024L;
                return l2;
            }
            LOG.error("Cannot determine the size of the physical memory for Linux host (using '/proc/meminfo'). Unexpected format.");
            l = -1L;
        }
        catch (NumberFormatException e) {
            LOG.error("Cannot determine the size of the physical memory for Linux host (using '/proc/meminfo'). Unexpected format.");
            long l3 = -1L;
            return l3;
        }
        catch (Throwable t) {
            LOG.error("Cannot determine the size of the physical memory for Linux host (using '/proc/meminfo'): " + t.getMessage(), t);
            long l4 = -1L;
            try {
                if (lineReader != null) {
                    lineReader.close();
                }
            }
            catch (Throwable t2) {
                // empty catch block
            }
            return l4;
        }
        finally {
            try {
                if (lineReader != null) {
                    lineReader.close();
                }
            }
            catch (Throwable t) {}
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getSizeOfPhysicalMemoryForMac() {
        BufferedReader bi;
        block16: {
            long l;
            block15: {
                bi = null;
                try {
                    String line;
                    Process proc = Runtime.getRuntime().exec("sysctl hw.memsize");
                    bi = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = bi.readLine()) != null) {
                        if (!line.startsWith("hw.memsize")) continue;
                        long memsize = Long.parseLong(line.split(":")[1].trim());
                        bi.close();
                        proc.destroy();
                        l = memsize;
                        if (bi == null) return l;
                        break block15;
                    }
                    break block16;
                }
                catch (Throwable t) {
                    try {
                        LOG.error("Cannot determine physical memory of machine for MacOS host: " + t.getMessage(), t);
                        long l2 = -1L;
                        return l2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (bi != null) {
                            try {
                                bi.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
            }
            try {
                bi.close();
                return l;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return l;
        }
        if (bi == null) return -1L;
        try {
            bi.close();
            return -1L;
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getSizeOfPhysicalMemoryForFreeBSD() {
        block16: {
            bi = null;
            try {
                proc = Runtime.getRuntime().exec("sysctl hw.physmem");
                bi = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((line = bi.readLine()) != null) {
                    if (!line.startsWith("hw.physmem")) continue;
                    memsize = Long.parseLong(line.split(":")[1].trim());
                    bi.close();
                    proc.destroy();
                    var5_6 = memsize;
                    if (bi == null) return var5_6;
                    break block16;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable t) {
                try {
                    Hardware.LOG.error("Cannot determine the size of the physical memory for FreeBSD host (using 'sysctl hw.physmem'): " + t.getMessage(), t);
                    var9_9 = -1L;
                    return var9_9;
                }
                catch (Throwable var12_11) {
                    throw var12_11;
                }
                finally {
                    if (bi != null) {
                        try {
                            bi.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        try {
            bi.close();
            return var5_6;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return var5_6;
lbl-1000:
        // 1 sources

        {
            Hardware.LOG.error("Cannot determine the size of the physical memory for FreeBSD host (using 'sysctl hw.physmem').");
            var3_5 = -1L;
            if (bi == null) return var3_5;
        }
        try {
            bi.close();
            return var3_5;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return var3_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long getSizeOfPhysicalMemoryForWindows() {
        long l;
        BufferedReader bi;
        block23: {
            String line;
            block21: {
                long l2;
                block22: {
                    block19: {
                        long l3;
                        block20: {
                            bi = null;
                            Process proc = Runtime.getRuntime().exec("wmic memorychip get capacity");
                            bi = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            line = bi.readLine();
                            if (line != null) break block19;
                            l3 = -1L;
                            if (bi == null) break block20;
                            try {
                                bi.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        return l3;
                    }
                    if (line.startsWith("Capacity")) break block21;
                    l2 = -1L;
                    if (bi == null) break block22;
                    try {
                        bi.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                return l2;
            }
            long sizeOfPhyiscalMemory = 0L;
            while ((line = bi.readLine()) != null) {
                if (line.isEmpty()) continue;
                line = line.replaceAll(" ", "");
                sizeOfPhyiscalMemory += Long.parseLong(line);
            }
            l = sizeOfPhyiscalMemory;
            if (bi == null) break block23;
            try {
                bi.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return l;
        catch (Throwable t) {
            try {
                LOG.error("Cannot determine the size of the physical memory for Windows host (using 'wmic memorychip'): " + t.getMessage(), t);
                long l4 = -1L;
                return l4;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (bi != null) {
                    try {
                        bi.close();
                    }
                    catch (Throwable t2) {}
                }
            }
        }
    }

    private Hardware() {
    }
}

