/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.ExecutionMode;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.slf4j.LoggerFactory;

public class LocalInstanceManager
extends InstanceManager {
    private final List<TaskManager> taskManagers = new ArrayList<TaskManager>();

    public LocalInstanceManager(int numTaskManagers) throws Exception {
        ExecutionMode execMode = numTaskManagers == 1 ? ExecutionMode.LOCAL : ExecutionMode.CLUSTER;
        int ipcPort = GlobalConfiguration.getInteger((String)"taskmanager.rpc.port", (int)-1);
        int dataPort = GlobalConfiguration.getInteger((String)"taskmanager.data.port", (int)-1);
        for (int i = 0; i < numTaskManagers; ++i) {
            if (ipcPort > 0 || dataPort > 0) {
                Configuration tm = new Configuration();
                if (ipcPort > 0) {
                    tm.setInteger("taskmanager.rpc.port", ipcPort + i);
                }
                if (dataPort > 0) {
                    tm.setInteger("taskmanager.data.port", dataPort + i);
                }
                GlobalConfiguration.includeConfiguration((Configuration)tm);
            }
            this.taskManagers.add(TaskManager.createTaskManager(execMode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            for (TaskManager taskManager : this.taskManagers) {
                try {
                    taskManager.shutdown();
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(LocalInstanceManager.class).error("Error shutting down local embedded TaskManager.", t);
                }
            }
        }
        finally {
            this.taskManagers.clear();
            super.shutdown();
        }
    }

    public TaskManager[] getTaskManagers() {
        return this.taskManagers.toArray(new TaskManager[this.taskManagers.size()]);
    }
}

