/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.protocols.VersionedProtocol;
import org.apache.flink.runtime.ipc.Client;
import org.apache.flink.runtime.net.NetUtils;
import org.apache.flink.types.JavaToValueConverter;
import org.apache.flink.types.Value;
import org.apache.flink.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPC {
    private static final Logger LOG = LoggerFactory.getLogger(RPC.class);
    private static ClientCache CLIENTS = new ClientCache();

    private RPC() {
    }

    public static VersionedProtocol waitForProxy(Class<? extends VersionedProtocol> protocol, InetSocketAddress addr) throws IOException {
        return RPC.waitForProxy(protocol, addr, Long.MAX_VALUE);
    }

    static <V extends VersionedProtocol> V waitForProxy(Class<V> protocol, InetSocketAddress addr, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        while (true) {
            IOException ioe;
            try {
                return RPC.getProxy(protocol, addr);
            }
            catch (ConnectException se) {
                LOG.info("Server at " + addr + " not available yet, Zzzzz...");
                ioe = se;
            }
            catch (SocketTimeoutException te) {
                LOG.info("Problem connecting to server: " + addr);
                ioe = te;
            }
            if (System.currentTimeMillis() - timeout >= startTime) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public static <V extends VersionedProtocol> V getProxy(Class<V> protocol, InetSocketAddress addr, SocketFactory factory) throws IOException {
        VersionedProtocol proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(addr, factory));
        return (V)proxy;
    }

    public static <V extends VersionedProtocol> V getProxy(Class<V> protocol, InetSocketAddress addr) throws IOException {
        return RPC.getProxy(protocol, addr, NetUtils.getDefaultSocketFactory());
    }

    public static void stopProxy(VersionedProtocol proxy) {
        if (proxy != null) {
            ((Invoker)Proxy.getInvocationHandler(proxy)).close();
        }
    }

    public static Server getServer(Object instance, String bindAddress, int port, int numHandlers) throws IOException {
        return new Server(instance, bindAddress, port, numHandlers);
    }

    public static class Server
    extends org.apache.flink.runtime.ipc.Server {
        private Object instance;

        public Server(Object instance, String bindAddress, int port) throws IOException {
            this(instance, bindAddress, port, 1);
        }

        private static String classNameBase(String className) {
            String[] names = className.split("\\.", -1);
            if (names == null || names.length == 0) {
                return className;
            }
            return names[names.length - 1];
        }

        public Server(Object instance, String bindAddress, int port, int numHandlers) throws IOException {
            super(bindAddress, port, Invocation.class, numHandlers, Server.classNameBase(instance.getClass().getName()));
            this.instance = instance;
        }

        @Override
        public IOReadableWritable call(Class<?> protocol, IOReadableWritable param, long receivedTime) throws IOException {
            try {
                Invocation call = (Invocation)param;
                call.undoTypeConversion();
                Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
                method.setAccessible(true);
                Object value = method.invoke(this.instance, call.getParameters());
                if (IOReadableWritable.class.isAssignableFrom(method.getReturnType())) {
                    return (IOReadableWritable)value;
                }
                try {
                    return JavaToValueConverter.convertBoxedJavaType((Object)value);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("The return type of method " + method.getName() + " is not a primitive type (or boxed primitive) and not of type IOReadableWriteable");
                }
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof IOException) {
                    throw (IOException)target;
                }
                IOException ioe = new IOException(target.toString());
                ioe.setStackTrace(target.getStackTrace());
                throw ioe;
            }
            catch (Throwable e) {
                IOException ioe = new IOException(e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private InetSocketAddress address;
        private Client client;
        private boolean isClosed = false;

        public Invoker(InetSocketAddress address, SocketFactory factory) {
            this.address = address;
            this.client = CLIENTS.getClient(factory);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Invocation invocation = new Invocation(method, args);
            invocation.doTypeConversion();
            IOReadableWritable retValue = this.client.call(invocation, this.address, method.getDeclaringClass());
            if (IOReadableWritable.class.isAssignableFrom(method.getReturnType())) {
                return retValue;
            }
            return JavaToValueConverter.convertValueType((Value)((Value)retValue));
        }

        private synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class ClientCache {
        private Map<SocketFactory, Client> clients = new HashMap<SocketFactory, Client>();

        private ClientCache() {
        }

        private synchronized Client getClient(SocketFactory factory) {
            Client client = this.clients.get(factory);
            if (client == null) {
                client = new Client(factory);
                this.clients.put(factory, client);
            } else {
                client.incCount();
            }
            return client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopClient(Client client) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                client.decCount();
                if (client.isZeroReference()) {
                    this.clients.remove(client.getSocketFactory());
                }
            }
            if (client.isZeroReference()) {
                client.stop();
            }
        }
    }

    private static class Invocation
    implements IOReadableWritable {
        private String methodName;
        private Class<?>[] parameterClasses;
        private Object[] parameters;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterClasses() {
            return this.parameterClasses;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public void read(DataInputView in) throws IOException {
            this.methodName = StringRecord.readString((DataInput)in);
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                String className = StringRecord.readString((DataInput)in);
                try {
                    this.parameterClasses[i] = ClassUtils.resolveClassPrimitiveAware((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
                if (in.readBoolean()) {
                    IOReadableWritable value;
                    try {
                        String parameterClassName = StringRecord.readString((DataInput)in);
                        Class parameterClass = ClassUtils.resolveClassPrimitiveAware((String)parameterClassName);
                        value = (IOReadableWritable)parameterClass.newInstance();
                        this.parameters[i] = value;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    value.read(in);
                    continue;
                }
                this.parameters[i] = null;
            }
        }

        public void write(DataOutputView out) throws IOException {
            StringRecord.writeString((DataOutput)out, (String)this.methodName);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                StringRecord.writeString((DataOutput)out, (String)this.parameterClasses[i].getName());
                if (this.parameters[i] == null) {
                    out.writeBoolean(false);
                    continue;
                }
                out.writeBoolean(true);
                StringRecord.writeString((DataOutput)out, (String)this.parameters[i].getClass().getName());
                ((IOReadableWritable)this.parameters[i]).write(out);
            }
        }

        public void doTypeConversion() throws IOException {
            try {
                for (int i = 0; i < this.parameterClasses.length; ++i) {
                    if (IOReadableWritable.class.isAssignableFrom(this.parameterClasses[i])) continue;
                    try {
                        this.parameters[i] = JavaToValueConverter.convertBoxedJavaType((Object)this.parameters[i]);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Argument " + i + " of method " + this.methodName + " is not a primitive type (or boxed primitive) and not of type IOReadableWriteable");
                    }
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new IOException(e);
            }
        }

        public void undoTypeConversion() {
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                if (IOReadableWritable.class.isAssignableFrom(this.parameterClasses[i])) continue;
                this.parameters[i] = JavaToValueConverter.convertValueType((Value)((Value)this.parameters[i]));
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.methodName);
            buffer.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

