/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.functions.FlatCombineFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.sort.FixedLengthRecordSorter;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.NormalizedKeySorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupReduceCombineDriver<T>
implements PactDriver<FlatCombineFunction<T>, T> {
    private static final Logger LOG = LoggerFactory.getLogger(GroupReduceCombineDriver.class);
    private static final int THRESHOLD_FOR_IN_PLACE_SORTING = 32;
    private PactTaskContext<FlatCombineFunction<T>, T> taskContext;
    private InMemorySorter<T> sorter;
    private FlatCombineFunction<T> combiner;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> sortingComparator;
    private TypeComparator<T> groupingComparator;
    private QuickSort sortAlgo = new QuickSort();
    private MemoryManager memManager;
    private Collector<T> output;
    private volatile boolean running = true;

    @Override
    public void setup(PactTaskContext<FlatCombineFunction<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<FlatCombineFunction<T>> getStubType() {
        Class<FlatCombineFunction> clazz = FlatCombineFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 2;
    }

    @Override
    public void prepare() throws Exception {
        if (this.taskContext.getTaskConfig().getDriverStrategy() != DriverStrategy.SORTED_GROUP_COMBINE) {
            throw new Exception("Invalid strategy " + (Object)((Object)this.taskContext.getTaskConfig().getDriverStrategy()) + " for " + "group reduce combinder.");
        }
        this.memManager = this.taskContext.getMemoryManager();
        int numMemoryPages = this.memManager.computeNumberOfPages(this.taskContext.getTaskConfig().getRelativeMemoryDriver());
        TypeSerializerFactory serializerFactory = this.taskContext.getInputSerializer(0);
        this.serializer = serializerFactory.getSerializer();
        this.sortingComparator = this.taskContext.getDriverComparator(0);
        this.groupingComparator = this.taskContext.getDriverComparator(1);
        this.combiner = this.taskContext.getStub();
        this.output = this.taskContext.getOutputCollector();
        List<MemorySegment> memory = this.memManager.allocatePages(this.taskContext.getOwningNepheleTask(), numMemoryPages);
        this.sorter = this.sortingComparator.supportsSerializationWithKeyNormalization() && this.serializer.getLength() > 0 && this.serializer.getLength() <= 32 ? new FixedLengthRecordSorter<T>(this.serializer, this.sortingComparator, memory) : new NormalizedKeySorter<T>(this.serializer, this.sortingComparator.duplicate(), memory);
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Combiner starting.");
        }
        MutableObjectIterator in = this.taskContext.getInput(0);
        TypeSerializer<T> serializer = this.serializer;
        Object value = serializer.createInstance();
        while (this.running && (value = in.next(value)) != null) {
            if (this.sorter.write(value)) continue;
            this.sortAndCombine();
            this.sorter.reset();
            if (this.sorter.write(value)) continue;
            throw new IOException("Cannot write record to fresh sort buffer. Record too large.");
        }
        this.sortAndCombine();
    }

    private void sortAndCombine() throws Exception {
        InMemorySorter<T> sorter = this.sorter;
        if (!sorter.isEmpty()) {
            this.sortAlgo.sort(sorter);
            KeyGroupedIterator<T> keyIter = new KeyGroupedIterator<T>(sorter.getIterator(), this.serializer, this.groupingComparator);
            FlatCombineFunction<T> combiner = this.combiner;
            Collector<T> output = this.output;
            while (this.running && keyIter.nextKey()) {
                combiner.combine((Iterable)keyIter.getValues(), output);
            }
        }
    }

    @Override
    public void cleanup() throws Exception {
        if (this.sorter != null) {
            this.memManager.release(this.sorter.dispose());
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        if (this.sorter != null) {
            this.memManager.release(this.sorter.dispose());
        }
    }
}

