/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.SpillingBuffer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memorymanager.ListMemorySegmentSource;
import org.apache.flink.runtime.memorymanager.MemoryAllocationException;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.util.ResettableMutableObjectIterator;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpillingResettableMutableObjectIterator<T>
implements ResettableMutableObjectIterator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SpillingResettableMutableObjectIterator.class);
    protected DataInputView inView;
    protected final TypeSerializer<T> serializer;
    private int elementCount;
    private int currentElementNum;
    protected final SpillingBuffer buffer;
    protected final MutableObjectIterator<T> input;
    protected final MemoryManager memoryManager;
    private final List<MemorySegment> memorySegments;
    private final boolean releaseMemoryOnClose;

    public SpillingResettableMutableObjectIterator(MutableObjectIterator<T> input, TypeSerializer<T> serializer, MemoryManager memoryManager, IOManager ioManager, int numPages, AbstractInvokable parentTask) throws MemoryAllocationException {
        this(input, serializer, memoryManager, ioManager, memoryManager.allocatePages(parentTask, numPages), true);
    }

    public SpillingResettableMutableObjectIterator(MutableObjectIterator<T> input, TypeSerializer<T> serializer, MemoryManager memoryManager, IOManager ioManager, List<MemorySegment> memory) {
        this(input, serializer, memoryManager, ioManager, memory, false);
    }

    private SpillingResettableMutableObjectIterator(MutableObjectIterator<T> input, TypeSerializer<T> serializer, MemoryManager memoryManager, IOManager ioManager, List<MemorySegment> memory, boolean releaseMemOnClose) {
        this.memoryManager = memoryManager;
        this.input = input;
        this.serializer = serializer;
        this.memorySegments = memory;
        this.releaseMemoryOnClose = releaseMemOnClose;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating spilling resettable iterator with " + memory.size() + " pages of memory.");
        }
        this.buffer = new SpillingBuffer(ioManager, new ListMemorySegmentSource(memory), memoryManager.getPageSize());
    }

    public void open() {
    }

    @Override
    public void reset() throws IOException {
        this.inView = this.buffer.flip();
        this.currentElementNum = 0;
    }

    public List<MemorySegment> close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Spilling Resettable Iterator closing. Stored " + this.elementCount + " records.");
        }
        this.inView = null;
        List<MemorySegment> memory = this.buffer.close();
        memory.addAll(this.memorySegments);
        this.memorySegments.clear();
        if (this.releaseMemoryOnClose) {
            this.memoryManager.release(memory);
            return Collections.emptyList();
        }
        return memory;
    }

    public T next(T reuse) throws IOException {
        if (this.inView != null) {
            if (this.currentElementNum < this.elementCount) {
                try {
                    reuse = this.serializer.deserialize(reuse, this.inView);
                }
                catch (IOException e) {
                    throw new RuntimeException("SpillingIterator: Error reading element from buffer.", e);
                }
                ++this.currentElementNum;
                return reuse;
            }
            return null;
        }
        if ((reuse = this.input.next(reuse)) != null) {
            try {
                this.serializer.serialize(reuse, (DataOutputView)this.buffer);
            }
            catch (IOException e) {
                throw new RuntimeException("SpillingIterator: Error writing element to buffer.", e);
            }
            ++this.elementCount;
            return reuse;
        }
        return null;
    }

    public void consumeAndCacheRemainingData() throws IOException {
        if (this.inView == null) {
            Object holder = this.serializer.createInstance();
            while ((holder = this.input.next(holder)) != null) {
                try {
                    this.serializer.serialize(holder, (DataOutputView)this.buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException("SpillingIterator: Error writing element to buffer.", e);
                }
                ++this.elementCount;
            }
        }
    }
}

