/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.types.StringValue;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static <T extends Enum<T>> T readEnum(DataInput in, Class<T> enumType) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return Enum.valueOf(enumType, StringValue.readString((DataInput)in));
    }

    public static void writeEnum(DataOutput out, Enum<?> enumVal) throws IOException {
        if (enumVal == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            StringValue.writeString((CharSequence)enumVal.name(), (DataOutput)out);
        }
    }
}

