/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.SlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolServiceFactory;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.scheduler.DefaultSchedulerFactory;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveSchedulerFactory;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSlotPoolServiceSchedulerFactory
implements SlotPoolServiceSchedulerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSlotPoolServiceSchedulerFactory.class);
    private final SlotPoolServiceFactory slotPoolServiceFactory;
    private final SchedulerNGFactory schedulerNGFactory;

    private DefaultSlotPoolServiceSchedulerFactory(SlotPoolServiceFactory slotPoolServiceFactory, SchedulerNGFactory schedulerNGFactory) {
        this.slotPoolServiceFactory = slotPoolServiceFactory;
        this.schedulerNGFactory = schedulerNGFactory;
    }

    @VisibleForTesting
    SchedulerNGFactory getSchedulerNGFactory() {
        return this.schedulerNGFactory;
    }

    @Override
    public SlotPoolService createSlotPoolService(JobID jid) {
        return this.slotPoolServiceFactory.createSlotPoolService(jid);
    }

    @Override
    public JobManagerOptions.SchedulerType getSchedulerType() {
        return this.schedulerNGFactory.getSchedulerType();
    }

    @Override
    public SchedulerNG createScheduler(Logger log, JobGraph jobGraph, Executor ioExecutor, Configuration configuration, SlotPoolService slotPoolService, ScheduledExecutorService futureExecutor, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Time rpcTimeout, BlobWriter blobWriter, JobManagerJobMetricGroup jobManagerJobMetricGroup, Time slotRequestTimeout, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker, ExecutionDeploymentTracker executionDeploymentTracker, long initializationTimestamp, ComponentMainThreadExecutor mainThreadExecutor, FatalErrorHandler fatalErrorHandler, JobStatusListener jobStatusListener) throws Exception {
        return this.schedulerNGFactory.createInstance(log, jobGraph, ioExecutor, configuration, slotPoolService, futureExecutor, userCodeLoader, checkpointRecoveryFactory, rpcTimeout, blobWriter, jobManagerJobMetricGroup, slotRequestTimeout, shuffleMaster, partitionTracker, executionDeploymentTracker, initializationTimestamp, mainThreadExecutor, fatalErrorHandler, jobStatusListener);
    }

    public static DefaultSlotPoolServiceSchedulerFactory create(SlotPoolServiceFactory slotPoolServiceFactory, SchedulerNGFactory schedulerNGFactory) {
        return new DefaultSlotPoolServiceSchedulerFactory(slotPoolServiceFactory, schedulerNGFactory);
    }

    public static DefaultSlotPoolServiceSchedulerFactory fromConfiguration(Configuration configuration, JobType jobType) {
        SlotPoolServiceFactory slotPoolServiceFactory;
        SchedulerNGFactory schedulerNGFactory;
        Time rpcTimeout = Time.fromDuration((Duration)((Duration)configuration.get(AkkaOptions.ASK_TIMEOUT_DURATION)));
        Time slotIdleTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_IDLE_TIMEOUT));
        Time batchSlotTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT));
        JobManagerOptions.SchedulerType schedulerType = ClusterOptions.getSchedulerType((Configuration)configuration);
        if (schedulerType == JobManagerOptions.SchedulerType.Adaptive && jobType == JobType.BATCH) {
            LOG.info("Adaptive Scheduler configured, but Batch job detected. Changing scheduler type to NG / DefaultScheduler.");
            schedulerType = JobManagerOptions.SchedulerType.Ng;
        }
        switch (schedulerType) {
            case Ng: {
                schedulerNGFactory = new DefaultSchedulerFactory();
                slotPoolServiceFactory = new DeclarativeSlotPoolBridgeServiceFactory((Clock)SystemClock.getInstance(), rpcTimeout, slotIdleTimeout, batchSlotTimeout);
                break;
            }
            case Adaptive: {
                schedulerNGFactory = DefaultSlotPoolServiceSchedulerFactory.getAdaptiveSchedulerFactoryFromConfiguration(configuration);
                slotPoolServiceFactory = new DeclarativeSlotPoolServiceFactory((Clock)SystemClock.getInstance(), slotIdleTimeout, rpcTimeout);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Illegal value [%s] for config option [%s]", schedulerType, JobManagerOptions.SCHEDULER.key()));
            }
        }
        return new DefaultSlotPoolServiceSchedulerFactory(slotPoolServiceFactory, schedulerNGFactory);
    }

    private static AdaptiveSchedulerFactory getAdaptiveSchedulerFactoryFromConfiguration(Configuration configuration) {
        Duration allocationTimeoutDefault = (Duration)JobManagerOptions.RESOURCE_WAIT_TIMEOUT.defaultValue();
        Duration stabilizationTimeoutDefault = (Duration)JobManagerOptions.RESOURCE_STABILIZATION_TIMEOUT.defaultValue();
        if (configuration.get(JobManagerOptions.SCHEDULER_MODE) == SchedulerExecutionMode.REACTIVE) {
            allocationTimeoutDefault = Duration.ofMillis(-1L);
            stabilizationTimeoutDefault = Duration.ZERO;
        }
        Duration initialResourceAllocationTimeout = configuration.getOptional(JobManagerOptions.RESOURCE_WAIT_TIMEOUT).orElse(allocationTimeoutDefault);
        Duration resourceStabilizationTimeout = configuration.getOptional(JobManagerOptions.RESOURCE_STABILIZATION_TIMEOUT).orElse(stabilizationTimeoutDefault);
        return new AdaptiveSchedulerFactory(initialResourceAllocationTimeout, resourceStabilizationTimeout);
    }
}

