/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.InetAddress;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConfig.class);
    static final String SERVER_THREAD_GROUP_NAME = "Flink Netty Server";
    static final String CLIENT_THREAD_GROUP_NAME = "Flink Netty Client";
    private final InetAddress serverAddress;
    private final int serverPort;
    private final int memorySegmentSize;
    private final int numberOfSlots;
    private final Configuration config;

    public NettyConfig(InetAddress serverAddress, int serverPort, int memorySegmentSize, int numberOfSlots, Configuration config) {
        this.serverAddress = (InetAddress)Preconditions.checkNotNull((Object)serverAddress);
        Preconditions.checkArgument((boolean)NetUtils.isValidHostPort((int)serverPort), (Object)"Invalid port number.");
        this.serverPort = serverPort;
        Preconditions.checkArgument((memorySegmentSize > 0 ? 1 : 0) != 0, (Object)"Invalid memory segment size.");
        this.memorySegmentSize = memorySegmentSize;
        Preconditions.checkArgument((numberOfSlots > 0 ? 1 : 0) != 0, (Object)"Number of slots");
        this.numberOfSlots = numberOfSlots;
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
        LOG.info(this.toString());
    }

    InetAddress getServerAddress() {
        return this.serverAddress;
    }

    int getServerPort() {
        return this.serverPort;
    }

    public int getServerConnectBacklog() {
        return this.config.getInteger(NettyShuffleEnvironmentOptions.CONNECT_BACKLOG);
    }

    public int getNumberOfArenas() {
        int configValue = this.config.getInteger(NettyShuffleEnvironmentOptions.NUM_ARENAS);
        return configValue == -1 ? this.numberOfSlots : configValue;
    }

    public int getServerNumThreads() {
        int configValue = this.config.getInteger(NettyShuffleEnvironmentOptions.NUM_THREADS_SERVER);
        return configValue == -1 ? this.numberOfSlots : configValue;
    }

    public int getClientNumThreads() {
        int configValue = this.config.getInteger(NettyShuffleEnvironmentOptions.NUM_THREADS_CLIENT);
        return configValue == -1 ? this.numberOfSlots : configValue;
    }

    public int getClientConnectTimeoutSeconds() {
        return this.config.getInteger(NettyShuffleEnvironmentOptions.CLIENT_CONNECT_TIMEOUT_SECONDS);
    }

    public int getNetworkRetries() {
        return this.config.getInteger(NettyShuffleEnvironmentOptions.NETWORK_RETRIES);
    }

    public int getSendAndReceiveBufferSize() {
        return this.config.getInteger(NettyShuffleEnvironmentOptions.SEND_RECEIVE_BUFFER_SIZE);
    }

    public TransportType getTransportType() {
        String transport;
        switch (transport = this.config.getString(NettyShuffleEnvironmentOptions.TRANSPORT_TYPE)) {
            case "nio": {
                return TransportType.NIO;
            }
            case "epoll": {
                return TransportType.EPOLL;
            }
        }
        return TransportType.AUTO;
    }

    public Optional<Integer> getTcpKeepIdleInSeconds() {
        return this.config.getOptional(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_IDLE_SECONDS);
    }

    public Optional<Integer> getTcpKeepInternalInSeconds() {
        return this.config.getOptional(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_INTERVAL_SECONDS);
    }

    public Optional<Integer> getTcpKeepCount() {
        return this.config.getOptional(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_COUNT);
    }

    @Nullable
    public SSLHandlerFactory createClientSSLEngineFactory() throws Exception {
        return this.getSSLEnabled() ? SSLUtils.createInternalClientSSLEngineFactory(this.config) : null;
    }

    @Nullable
    public SSLHandlerFactory createServerSSLEngineFactory() throws Exception {
        return this.getSSLEnabled() ? SSLUtils.createInternalServerSSLEngineFactory(this.config) : null;
    }

    public boolean getSSLEnabled() {
        return this.config.getBoolean(NettyShuffleEnvironmentOptions.DATA_SSL_ENABLED) && SecurityOptions.isInternalSSLEnabled((Configuration)this.config);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String toString() {
        String format = "NettyConfig [server address: %s, server port: %d, ssl enabled: %s, memory segment size (bytes): %d, transport type: %s, number of server threads: %d (%s), number of client threads: %d (%s), server connect backlog: %d (%s), client connect timeout (sec): %d, send/receive buffer size (bytes): %d (%s)]";
        String def = "use Netty's default";
        String man = "manual";
        return String.format(format, new Object[]{this.serverAddress, this.serverPort, this.getSSLEnabled() ? "true" : "false", this.memorySegmentSize, this.getTransportType(), this.getServerNumThreads(), this.getServerNumThreads() == 0 ? def : man, this.getClientNumThreads(), this.getClientNumThreads() == 0 ? def : man, this.getServerConnectBacklog(), this.getServerConnectBacklog() == 0 ? def : man, this.getClientConnectTimeoutSeconds(), this.getSendAndReceiveBufferSize(), this.getSendAndReceiveBufferSize() == 0 ? def : man});
    }

    static enum TransportType {
        NIO,
        EPOLL,
        AUTO;

    }
}

