/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.internal.MetricAware;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.internal.SdkFilterInputStream;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.metrics.AwsSdkMetrics;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.metrics.MetricFilterInputStream;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.metrics.S3ServiceMetric;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.util.IOUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.client.methods.HttpRequestBase;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;
    private boolean eof;

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest) {
        this(in, httpRequest, S3ObjectInputStream.wrapWithByteCounting(in));
    }

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest, boolean collectMetrics) {
        super(collectMetrics ? new MetricFilterInputStream(S3ServiceMetric.S3DownloadThroughput, in) : in);
        this.httpRequest = httpRequest;
    }

    private static boolean wrapWithByteCounting(InputStream in) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (in instanceof MetricAware) {
            MetricAware aware = (MetricAware)((Object)in);
            return !aware.isMetricActivated();
        }
        return true;
    }

    @Override
    public void abort() {
        this.doAbort();
    }

    private void doAbort() {
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly(this.in, null);
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public int available() throws IOException {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = super.read(b, off, len);
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.eof = false;
    }

    @Override
    public void close() throws IOException {
        if (this.eof) {
            super.close();
        } else {
            this.doAbort();
        }
    }
}

