/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Function;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Objects;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableBiMap;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableTable;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Iterables;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Maps;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class RegularImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    private final ImmutableSet<Table.Cell<R, C, V>> cellSet;
    private static final Function<Table.Cell<Object, Object, Object>, Object> GET_VALUE_FUNCTION = new Function<Table.Cell<Object, Object, Object>, Object>(){

        @Override
        public Object apply(Table.Cell<Object, Object, Object> from) {
            return from.getValue();
        }
    };
    @Nullable
    private volatile transient ImmutableList<V> valueList;

    private RegularImmutableTable(ImmutableSet<Table.Cell<R, C, V>> cellSet) {
        this.cellSet = cellSet;
    }

    private Function<Table.Cell<R, C, V>, V> getValueFunction() {
        return GET_VALUE_FUNCTION;
    }

    @Override
    public final ImmutableCollection<V> values() {
        ImmutableList<V> result = this.valueList;
        if (result == null) {
            this.valueList = result = ImmutableList.copyOf(Iterables.transform(this.cellSet(), this.getValueFunction()));
        }
        return result;
    }

    @Override
    public final int size() {
        return this.cellSet().size();
    }

    @Override
    public final boolean containsValue(@Nullable Object value) {
        return ((ImmutableCollection)this.values()).contains(value);
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return this.cellSet;
    }

    static final <R, C, V> RegularImmutableTable<R, C, V> forCells(List<Table.Cell<R, C, V>> cells, final @Nullable Comparator<? super R> rowComparator, final @Nullable Comparator<? super C> columnComparator) {
        Preconditions.checkNotNull(cells);
        if (rowComparator != null || columnComparator != null) {
            Comparator comparator = new Comparator<Table.Cell<R, C, V>>(){

                @Override
                public int compare(Table.Cell<R, C, V> cell1, Table.Cell<R, C, V> cell2) {
                    int rowCompare;
                    int n = rowCompare = rowComparator == null ? 0 : rowComparator.compare(cell1.getRowKey(), cell2.getRowKey());
                    if (rowCompare != 0) {
                        return rowCompare;
                    }
                    return columnComparator == null ? 0 : columnComparator.compare(cell1.getColumnKey(), cell2.getColumnKey());
                }
            };
            Collections.sort(cells, comparator);
        }
        return RegularImmutableTable.forCellsInternal(cells, rowComparator, columnComparator);
    }

    static final <R, C, V> RegularImmutableTable<R, C, V> forCells(Iterable<Table.Cell<R, C, V>> cells) {
        return RegularImmutableTable.forCellsInternal(cells, null, null);
    }

    private static final <R, C, V> RegularImmutableTable<R, C, V> forCellsInternal(Iterable<Table.Cell<R, C, V>> cells, @Nullable Comparator<? super R> rowComparator, @Nullable Comparator<? super C> columnComparator) {
        ImmutableSet.Builder cellSetBuilder = ImmutableSet.builder();
        ImmutableSet.Builder rowSpaceBuilder = ImmutableSet.builder();
        ImmutableSet.Builder columnSpaceBuilder = ImmutableSet.builder();
        for (Table.Cell<R, C, V> cell : cells) {
            cellSetBuilder.add(cell);
            rowSpaceBuilder.add(cell.getRowKey());
            columnSpaceBuilder.add(cell.getColumnKey());
        }
        ImmutableCollection cellSet = cellSetBuilder.build();
        ImmutableSet rowSpace = rowSpaceBuilder.build();
        if (rowComparator != null) {
            ArrayList rowList = Lists.newArrayList(rowSpace);
            Collections.sort(rowList, rowComparator);
            rowSpace = ImmutableSet.copyOf(rowList);
        }
        ImmutableSet columnSpace = columnSpaceBuilder.build();
        if (columnComparator != null) {
            ArrayList columnList = Lists.newArrayList(columnSpace);
            Collections.sort(columnList, columnComparator);
            columnSpace = ImmutableSet.copyOf(columnList);
        }
        return cellSet.size() > rowSpace.size() * columnSpace.size() / 2 ? new DenseImmutableTable(cellSet, rowSpace, columnSpace) : new SparseImmutableTable(cellSet, rowSpace, columnSpace);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    @VisibleForTesting
    static final class DenseImmutableTable<R, C, V>
    extends RegularImmutableTable<R, C, V> {
        private final ImmutableBiMap<R, Integer> rowKeyToIndex;
        private final ImmutableBiMap<C, Integer> columnKeyToIndex;
        private final V[][] values;
        private volatile transient ImmutableMap<C, Map<R, V>> columnMap;
        private volatile transient ImmutableMap<R, Map<C, V>> rowMap;

        private static <E> ImmutableBiMap<E, Integer> makeIndex(ImmutableSet<E> set) {
            ImmutableBiMap.Builder indexBuilder = ImmutableBiMap.builder();
            int i = 0;
            for (Object key : set) {
                indexBuilder.put(key, (Object)i);
                ++i;
            }
            return indexBuilder.build();
        }

        DenseImmutableTable(ImmutableSet<Table.Cell<R, C, V>> cellSet, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
            super(cellSet);
            Object[][] array = new Object[rowSpace.size()][columnSpace.size()];
            this.values = array;
            this.rowKeyToIndex = DenseImmutableTable.makeIndex(rowSpace);
            this.columnKeyToIndex = DenseImmutableTable.makeIndex(columnSpace);
            for (Table.Cell cell : cellSet) {
                int columnIndex;
                Object rowKey = cell.getRowKey();
                Object columnKey = cell.getColumnKey();
                int rowIndex = this.rowKeyToIndex.get(rowKey);
                V existingValue = this.values[rowIndex][columnIndex = this.columnKeyToIndex.get(columnKey).intValue()];
                Preconditions.checkArgument(existingValue == null, "duplicate key: (%s, %s)", rowKey, columnKey);
                this.values[rowIndex][columnIndex] = cell.getValue();
            }
        }

        @Override
        public ImmutableMap<R, V> column(C columnKey) {
            Preconditions.checkNotNull(columnKey);
            Integer columnIndexInteger = this.columnKeyToIndex.get(columnKey);
            if (columnIndexInteger == null) {
                return ImmutableMap.of();
            }
            int columnIndex = columnIndexInteger;
            ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
            for (int i = 0; i < this.values.length; ++i) {
                V value = this.values[i][columnIndex];
                if (value == null) continue;
                columnBuilder.put(((ImmutableBiMap)this.rowKeyToIndex.inverse()).get(i), value);
            }
            return columnBuilder.build();
        }

        @Override
        public ImmutableSet<C> columnKeySet() {
            return this.columnKeyToIndex.keySet();
        }

        private ImmutableMap<C, Map<R, V>> makeColumnMap() {
            ImmutableMap.Builder columnMapBuilder = ImmutableMap.builder();
            for (int c = 0; c < this.columnKeyToIndex.size(); ++c) {
                ImmutableMap.Builder rowMapBuilder = ImmutableMap.builder();
                for (int r = 0; r < this.rowKeyToIndex.size(); ++r) {
                    V value = this.values[r][c];
                    if (value == null) continue;
                    rowMapBuilder.put(((ImmutableBiMap)this.rowKeyToIndex.inverse()).get(r), value);
                }
                columnMapBuilder.put(((ImmutableBiMap)this.columnKeyToIndex.inverse()).get(c), rowMapBuilder.build());
            }
            return columnMapBuilder.build();
        }

        @Override
        public ImmutableMap<C, Map<R, V>> columnMap() {
            ImmutableMap<C, Map<R, Map<R, V>>> result = this.columnMap;
            if (result == null) {
                this.columnMap = result = this.makeColumnMap();
            }
            return result;
        }

        @Override
        public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
            return this.get(rowKey, columnKey) != null;
        }

        @Override
        public boolean containsColumn(@Nullable Object columnKey) {
            return this.columnKeyToIndex.containsKey(columnKey);
        }

        @Override
        public boolean containsRow(@Nullable Object rowKey) {
            return this.rowKeyToIndex.containsKey(rowKey);
        }

        @Override
        public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
            Integer rowIndex = this.rowKeyToIndex.get(rowKey);
            Integer columnIndex = this.columnKeyToIndex.get(columnKey);
            return rowIndex == null || columnIndex == null ? null : (V)this.values[rowIndex][columnIndex];
        }

        @Override
        public ImmutableMap<C, V> row(R rowKey) {
            Preconditions.checkNotNull(rowKey);
            Integer rowIndex = this.rowKeyToIndex.get(rowKey);
            if (rowIndex == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder rowBuilder = ImmutableMap.builder();
            V[] row = this.values[rowIndex];
            for (int r = 0; r < row.length; ++r) {
                V value = row[r];
                if (value == null) continue;
                rowBuilder.put(((ImmutableBiMap)this.columnKeyToIndex.inverse()).get(r), value);
            }
            return rowBuilder.build();
        }

        @Override
        public ImmutableSet<R> rowKeySet() {
            return this.rowKeyToIndex.keySet();
        }

        private ImmutableMap<R, Map<C, V>> makeRowMap() {
            ImmutableMap.Builder rowMapBuilder = ImmutableMap.builder();
            for (int r = 0; r < this.values.length; ++r) {
                V[] row = this.values[r];
                ImmutableMap.Builder columnMapBuilder = ImmutableMap.builder();
                for (int c = 0; c < row.length; ++c) {
                    V value = row[c];
                    if (value == null) continue;
                    columnMapBuilder.put(((ImmutableBiMap)this.columnKeyToIndex.inverse()).get(c), value);
                }
                rowMapBuilder.put(((ImmutableBiMap)this.rowKeyToIndex.inverse()).get(r), columnMapBuilder.build());
            }
            return rowMapBuilder.build();
        }

        @Override
        public ImmutableMap<R, Map<C, V>> rowMap() {
            ImmutableMap<R, Map<C, Map<C, V>>> result = this.rowMap;
            if (result == null) {
                this.rowMap = result = this.makeRowMap();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    @VisibleForTesting
    static final class SparseImmutableTable<R, C, V>
    extends RegularImmutableTable<R, C, V> {
        private final ImmutableMap<R, Map<C, V>> rowMap;
        private final ImmutableMap<C, Map<R, V>> columnMap;

        private static final <A, B, V> Map<A, ImmutableMap.Builder<B, V>> makeIndexBuilder(ImmutableSet<A> keySpace) {
            LinkedHashMap indexBuilder = Maps.newLinkedHashMap();
            for (Object key : keySpace) {
                indexBuilder.put(key, ImmutableMap.builder());
            }
            return indexBuilder;
        }

        private static final <A, B, V> ImmutableMap<A, Map<B, V>> buildIndex(Map<A, ImmutableMap.Builder<B, V>> indexBuilder) {
            return ImmutableMap.copyOf(Maps.transformValues(indexBuilder, new Function<ImmutableMap.Builder<B, V>, Map<B, V>>(){

                @Override
                public Map<B, V> apply(ImmutableMap.Builder<B, V> from) {
                    return from.build();
                }
            }));
        }

        SparseImmutableTable(ImmutableSet<Table.Cell<R, C, V>> cellSet, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
            super(cellSet);
            Map rowIndexBuilder = SparseImmutableTable.makeIndexBuilder(rowSpace);
            Map columnIndexBuilder = SparseImmutableTable.makeIndexBuilder(columnSpace);
            for (Table.Cell cell : cellSet) {
                Object rowKey = cell.getRowKey();
                Object columnKey = cell.getColumnKey();
                Object value = cell.getValue();
                rowIndexBuilder.get(rowKey).put(columnKey, value);
                columnIndexBuilder.get(columnKey).put(rowKey, value);
            }
            this.rowMap = SparseImmutableTable.buildIndex(rowIndexBuilder);
            this.columnMap = SparseImmutableTable.buildIndex(columnIndexBuilder);
        }

        @Override
        public ImmutableMap<R, V> column(C columnKey) {
            Preconditions.checkNotNull(columnKey);
            return Objects.firstNonNull((ImmutableMap)this.columnMap.get(columnKey), ImmutableMap.of());
        }

        @Override
        public ImmutableSet<C> columnKeySet() {
            return this.columnMap.keySet();
        }

        @Override
        public ImmutableMap<C, Map<R, V>> columnMap() {
            return this.columnMap;
        }

        @Override
        public ImmutableMap<C, V> row(R rowKey) {
            Preconditions.checkNotNull(rowKey);
            return Objects.firstNonNull((ImmutableMap)this.rowMap.get(rowKey), ImmutableMap.of());
        }

        @Override
        public ImmutableSet<R> rowKeySet() {
            return this.rowMap.keySet();
        }

        @Override
        public ImmutableMap<R, Map<C, V>> rowMap() {
            return this.rowMap;
        }

        @Override
        public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
            Map<C, V> row = this.rowMap.get(rowKey);
            return row != null && row.containsKey(columnKey);
        }

        @Override
        public boolean containsColumn(@Nullable Object columnKey) {
            return this.columnMap.containsKey(columnKey);
        }

        @Override
        public boolean containsRow(@Nullable Object rowKey) {
            return this.rowMap.containsKey(rowKey);
        }

        @Override
        public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
            Map<C, V> row = this.rowMap.get(rowKey);
            return row == null ? null : (V)row.get(columnKey);
        }
    }
}

