/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.AuthenticatedCipherText;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.CipherHelper;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.CompositeKey;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.ConcatKDF;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.ConstantTimeUtils;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.HMAC;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.flink.fs.s3hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
class AESCBC {
    public static final int IV_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom randomGen) {
        byte[] bytes = new byte[16];
        randomGen.nextBytes(bytes);
        return bytes;
    }

    private static Cipher createAESCBCCipher(SecretKey secretKey, boolean forEncryption, byte[] iv, Provider provider) throws JOSEException {
        Cipher cipher;
        try {
            cipher = CipherHelper.getInstance("AES/CBC/PKCS5Padding", provider);
            SecretKeySpec keyspec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            if (forEncryption) {
                cipher.init(1, (Key)keyspec, ivSpec);
            } else {
                cipher.init(2, (Key)keyspec, ivSpec);
            }
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        return cipher;
    }

    public static byte[] encrypt(SecretKey secretKey, byte[] iv, byte[] plainText, Provider provider) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, true, iv, provider);
        try {
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static byte[] computeAADLength(byte[] aad) {
        int bitLength = aad.length * 8;
        return ByteBuffer.allocate(8).putLong(bitLength).array();
    }

    public static AuthenticatedCipherText encryptAuthenticated(SecretKey secretKey, byte[] iv, byte[] plainText, byte[] aad, Provider ceProvider, Provider macProvider) throws JOSEException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] cipherText = AESCBC.encrypt(compositeKey.getAESKey(), iv, plainText, ceProvider);
        byte[] al = AESCBC.computeAADLength(aad);
        int hmacInputLength = aad.length + iv.length + cipherText.length + al.length;
        byte[] hmacInput = ByteBuffer.allocate(hmacInputLength).put(aad).put(iv).put(cipherText).put(al).array();
        byte[] hmac = HMAC.compute(compositeKey.getMACKey(), hmacInput, macProvider);
        byte[] authTag = Arrays.copyOf(hmac, compositeKey.getTruncatedMACByteLength());
        return new AuthenticatedCipherText(cipherText, authTag);
    }

    public static AuthenticatedCipherText encryptWithConcatKDF(JWEHeader header, SecretKey secretKey, Base64URL encryptedKey, byte[] iv, byte[] plainText, Provider ceProvider, Provider macProvider) throws JOSEException {
        byte[] epu = null;
        if (header.getCustomParam("epu") instanceof String) {
            epu = new Base64URL((String)header.getCustomParam("epu")).decode();
        }
        byte[] epv = null;
        if (header.getCustomParam("epv") instanceof String) {
            epv = new Base64URL((String)header.getCustomParam("epv")).decode();
        }
        SecretKey altCEK = ConcatKDF.generateCEK(secretKey, header.getEncryptionMethod(), epu, epv);
        byte[] cipherText = AESCBC.encrypt(altCEK, iv, plainText, ceProvider);
        SecretKey cik = ConcatKDF.generateCIK(secretKey, header.getEncryptionMethod(), epu, epv);
        String macInput = header.toBase64URL().toString() + "." + encryptedKey.toString() + "." + Base64URL.encode(iv).toString() + "." + Base64URL.encode(cipherText);
        byte[] mac = HMAC.compute(cik, macInput.getBytes(), macProvider);
        return new AuthenticatedCipherText(cipherText, mac);
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] iv, byte[] cipherText, Provider provider) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, false, iv, provider);
        try {
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static byte[] decryptAuthenticated(SecretKey secretKey, byte[] iv, byte[] cipherText, byte[] aad, byte[] authTag, Provider ceProvider, Provider macProvider) throws JOSEException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] al = AESCBC.computeAADLength(aad);
        int hmacInputLength = aad.length + iv.length + cipherText.length + al.length;
        byte[] hmacInput = ByteBuffer.allocate(hmacInputLength).put(aad).put(iv).put(cipherText).put(al).array();
        byte[] hmac = HMAC.compute(compositeKey.getMACKey(), hmacInput, macProvider);
        byte[] expectedAuthTag = Arrays.copyOf(hmac, compositeKey.getTruncatedMACByteLength());
        boolean macCheckPassed = true;
        if (!ConstantTimeUtils.areEqual(expectedAuthTag, authTag)) {
            macCheckPassed = false;
        }
        byte[] plainText = AESCBC.decrypt(compositeKey.getAESKey(), iv, cipherText, ceProvider);
        if (!macCheckPassed) {
            throw new JOSEException("MAC check failed");
        }
        return plainText;
    }

    public static byte[] decryptWithConcatKDF(JWEHeader header, SecretKey secretKey, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag, Provider ceProvider, Provider macProvider) throws JOSEException {
        byte[] epu = null;
        if (header.getCustomParam("epu") instanceof String) {
            epu = new Base64URL((String)header.getCustomParam("epu")).decode();
        }
        byte[] epv = null;
        if (header.getCustomParam("epv") instanceof String) {
            epv = new Base64URL((String)header.getCustomParam("epv")).decode();
        }
        SecretKey cekAlt = ConcatKDF.generateCEK(secretKey, header.getEncryptionMethod(), epu, epv);
        byte[] plainText = AESCBC.decrypt(cekAlt, iv.decode(), cipherText.decode(), ceProvider);
        SecretKey cik = ConcatKDF.generateCIK(secretKey, header.getEncryptionMethod(), epu, epv);
        String macInput = header.toBase64URL().toString() + "." + encryptedKey.toString() + "." + iv.toString() + "." + cipherText.toString();
        byte[] mac = HMAC.compute(cik, macInput.getBytes(), macProvider);
        if (!ConstantTimeUtils.areEqual(authTag.decode(), mac)) {
            throw new JOSEException("HMAC integrity check failed");
        }
        return plainText;
    }

    private AESCBC() {
    }
}

