/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.util.List;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.ConnectionPool;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.ConnectionSpec;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.Handshake;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.OkHttpClient;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.Protocol;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.Request;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.Route;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.http.HttpConnection;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.http.HttpEngine;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.http.HttpTransport;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.http.RouteException;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.http.SocketConnector;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.http.SpdyTransport;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.http.Transport;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.SpdyConnection;
import org.apache.flink.fs.s3hadoop.shaded.okio.BufferedSink;
import org.apache.flink.fs.s3hadoop.shaded.okio.BufferedSource;

public final class Connection {
    private final ConnectionPool pool;
    private final Route route;
    private Socket socket;
    private boolean connected = false;
    private HttpConnection httpConnection;
    private SpdyConnection spdyConnection;
    private Protocol protocol = Protocol.HTTP_1_1;
    private long idleStartTimeNs;
    private Handshake handshake;
    private int recycleCount;
    private Object owner;

    public Connection(ConnectionPool pool, Route route) {
        this.pool = pool;
        this.route = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            return this.owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwner(Object owner) {
        if (this.isSpdy()) {
            return;
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != null) {
                throw new IllegalStateException("Connection already has an owner!");
            }
            this.owner = owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner == null) {
                return false;
            }
            this.owner = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeIfOwnedBy(Object owner) throws IOException {
        if (this.isSpdy()) {
            throw new IllegalStateException();
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != owner) {
                return;
            }
            this.owner = null;
        }
        this.socket.close();
    }

    void connect(int connectTimeout, int readTimeout, int writeTimeout, Request request, List<ConnectionSpec> connectionSpecs, boolean connectionRetryEnabled) throws RouteException {
        SocketConnector.ConnectedSocket connectedSocket;
        if (this.connected) {
            throw new IllegalStateException("already connected");
        }
        SocketConnector socketConnector = new SocketConnector(this, this.pool);
        if (this.route.address.getSslSocketFactory() != null) {
            connectedSocket = socketConnector.connectTls(connectTimeout, readTimeout, writeTimeout, request, this.route, connectionSpecs, connectionRetryEnabled);
        } else {
            if (!connectionSpecs.contains(ConnectionSpec.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not supported: " + connectionSpecs));
            }
            connectedSocket = socketConnector.connectCleartext(connectTimeout, readTimeout, this.route);
        }
        this.socket = connectedSocket.socket;
        this.handshake = connectedSocket.handshake;
        this.protocol = connectedSocket.alpnProtocol == null ? Protocol.HTTP_1_1 : connectedSocket.alpnProtocol;
        try {
            if (this.protocol == Protocol.SPDY_3 || this.protocol == Protocol.HTTP_2) {
                this.socket.setSoTimeout(0);
                this.spdyConnection = new SpdyConnection.Builder(this.route.address.uriHost, true, this.socket).protocol(this.protocol).build();
                this.spdyConnection.sendConnectionPreface();
            } else {
                this.httpConnection = new HttpConnection(this.pool, this, this.socket);
            }
        }
        catch (IOException e) {
            throw new RouteException(e);
        }
        this.connected = true;
    }

    void connectAndSetOwner(OkHttpClient client, Object owner, Request request) throws RouteException {
        this.setOwner(owner);
        if (!this.isConnected()) {
            List<ConnectionSpec> connectionSpecs = this.route.address.getConnectionSpecs();
            this.connect(client.getConnectTimeout(), client.getReadTimeout(), client.getWriteTimeout(), request, connectionSpecs, client.getRetryOnConnectionFailure());
            if (this.isSpdy()) {
                client.getConnectionPool().share(this);
            }
            client.routeDatabase().connected(this.getRoute());
        }
        this.setTimeouts(client.getReadTimeout(), client.getWriteTimeout());
    }

    boolean isConnected() {
        return this.connected;
    }

    public Route getRoute() {
        return this.route;
    }

    public Socket getSocket() {
        return this.socket;
    }

    BufferedSource rawSource() {
        if (this.httpConnection == null) {
            throw new UnsupportedOperationException();
        }
        return this.httpConnection.rawSource();
    }

    BufferedSink rawSink() {
        if (this.httpConnection == null) {
            throw new UnsupportedOperationException();
        }
        return this.httpConnection.rawSink();
    }

    boolean isAlive() {
        return !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    boolean isReadable() {
        if (this.httpConnection != null) {
            return this.httpConnection.isReadable();
        }
        return true;
    }

    void resetIdleStartTime() {
        if (this.spdyConnection != null) {
            throw new IllegalStateException("spdyConnection != null");
        }
        this.idleStartTimeNs = System.nanoTime();
    }

    boolean isIdle() {
        return this.spdyConnection == null || this.spdyConnection.isIdle();
    }

    long getIdleStartTimeNs() {
        return this.spdyConnection == null ? this.idleStartTimeNs : this.spdyConnection.getIdleStartTimeNs();
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    Transport newTransport(HttpEngine httpEngine) throws IOException {
        return this.spdyConnection != null ? new SpdyTransport(httpEngine, this.spdyConnection) : new HttpTransport(httpEngine, this.httpConnection);
    }

    boolean isSpdy() {
        return this.spdyConnection != null;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    void setProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    void setTimeouts(int readTimeoutMillis, int writeTimeoutMillis) throws RouteException {
        if (!this.connected) {
            throw new IllegalStateException("setTimeouts - not connected");
        }
        if (this.httpConnection != null) {
            try {
                this.socket.setSoTimeout(readTimeoutMillis);
            }
            catch (IOException e) {
                throw new RouteException(e);
            }
            this.httpConnection.setTimeouts(readTimeoutMillis, writeTimeoutMillis);
        }
    }

    void incrementRecycleCount() {
        ++this.recycleCount;
    }

    int recycleCount() {
        return this.recycleCount;
    }

    public String toString() {
        return "Connection{" + this.route.address.uriHost + ":" + this.route.address.uriPort + ", proxy=" + this.route.proxy + " hostAddress=" + this.route.inetSocketAddress.getAddress().getHostAddress() + " cipherSuite=" + (this.handshake != null ? this.handshake.cipherSuite() : "none") + " protocol=" + (Object)((Object)this.protocol) + '}';
    }
}

