/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.Protocol;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.Internal;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.NamedRunnable;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.Util;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.ErrorCode;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.FrameReader;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.FrameWriter;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.Header;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.HeadersMode;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.Http2;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.Ping;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.PushObserver;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.Settings;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.Spdy3;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.SpdyStream;
import org.apache.flink.fs.s3hadoop.shaded.com.squareup.okhttp.internal.spdy.Variant;
import org.apache.flink.fs.s3hadoop.shaded.okio.Buffer;
import org.apache.flink.fs.s3hadoop.shaded.okio.BufferedSource;
import org.apache.flink.fs.s3hadoop.shaded.okio.ByteString;
import org.apache.flink.fs.s3hadoop.shaded.okio.Okio;

public final class SpdyConnection
implements Closeable {
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp SpdyConnection", true));
    final Protocol protocol;
    final boolean client;
    private final IncomingStreamHandler handler;
    private final Map<Integer, SpdyStream> streams = new HashMap<Integer, SpdyStream>();
    private final String hostName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean shutdown;
    private long idleStartTimeNs = System.nanoTime();
    private final ExecutorService pushExecutor;
    private Map<Integer, Ping> pings;
    private final PushObserver pushObserver;
    private int nextPingId;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final Settings okHttpSettings = new Settings();
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    final Settings peerSettings = new Settings();
    private boolean receivedInitialPeerSettings = false;
    final Variant variant;
    final Socket socket;
    final FrameWriter frameWriter;
    final Reader readerRunnable;
    private final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    private SpdyConnection(Builder builder) throws IOException {
        this.protocol = builder.protocol;
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.handler = builder.handler;
        int n = this.nextStreamId = builder.client ? 1 : 2;
        if (builder.client && this.protocol == Protocol.HTTP_2) {
            this.nextStreamId += 2;
        }
        int n2 = this.nextPingId = builder.client ? 1 : 2;
        if (builder.client) {
            this.okHttpSettings.set(7, 0, 0x1000000);
        }
        this.hostName = builder.hostName;
        if (this.protocol == Protocol.HTTP_2) {
            this.variant = new Http2();
            this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(String.format("OkHttp %s Push Observer", this.hostName), true));
            this.peerSettings.set(7, 0, 65535);
            this.peerSettings.set(5, 0, 16384);
        } else if (this.protocol == Protocol.SPDY_3) {
            this.variant = new Spdy3();
            this.pushExecutor = null;
        } else {
            throw new AssertionError((Object)this.protocol);
        }
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize(65536);
        this.socket = builder.socket;
        this.frameWriter = this.variant.newWriter(Okio.buffer(Okio.sink(builder.socket)), this.client);
        this.readerRunnable = new Reader();
        new Thread(this.readerRunnable).start();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized SpdyStream getStream(int id) {
        return this.streams.get(id);
    }

    synchronized SpdyStream removeStream(int streamId) {
        SpdyStream stream = this.streams.remove(streamId);
        if (stream != null && this.streams.isEmpty()) {
            this.setIdle(true);
        }
        this.notifyAll();
        return stream;
    }

    private synchronized void setIdle(boolean value) {
        this.idleStartTimeNs = value ? System.nanoTime() : Long.MAX_VALUE;
    }

    public synchronized boolean isIdle() {
        return this.idleStartTimeNs != Long.MAX_VALUE;
    }

    public synchronized long getIdleStartTimeNs() {
        return this.idleStartTimeNs;
    }

    public SpdyStream pushStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        if (this.protocol != Protocol.HTTP_2) {
            throw new IllegalStateException("protocol != HTTP_2");
        }
        return this.newStream(associatedStreamId, requestHeaders, out, false);
    }

    public SpdyStream newStream(List<Header> requestHeaders, boolean out, boolean in) throws IOException {
        return this.newStream(0, requestHeaders, out, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpdyStream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out, boolean in) throws IOException {
        SpdyStream stream;
        boolean outFinished = !out;
        boolean inFinished = !in;
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int streamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new SpdyStream(streamId, this, outFinished, inFinished, requestHeaders);
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                    this.setIdle(false);
                }
            }
            if (associatedStreamId == 0) {
                this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, requestHeaders);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.frameWriter.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
        }
        if (!out) {
            this.frameWriter.flush();
        }
        return stream;
    }

    void writeSynReply(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        this.frameWriter.synReply(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.frameWriter.data(outFinished, streamId, buffer, 0);
            return;
        }
        while (byteCount > 0L) {
            int toWrite;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(byteCount, this.bytesLeftInWriteWindow);
                toWrite = Math.min(toWrite, this.frameWriter.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)toWrite;
            }
            this.frameWriter.data(outFinished && (byteCount -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    void addBytesToWriteWindow(long delta) {
        this.bytesLeftInWriteWindow += delta;
        if (delta > 0L) {
            this.notifyAll();
        }
    }

    void writeSynResetLater(final int streamId, final ErrorCode errorCode) {
        executor.submit(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.writeSynReset(streamId, errorCode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeSynReset(int streamId, ErrorCode statusCode) throws IOException {
        this.frameWriter.rstStream(streamId, statusCode);
    }

    void writeWindowUpdateLater(final int streamId, final long unacknowledgedBytesRead) {
        executor.execute(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.frameWriter.windowUpdate(streamId, unacknowledgedBytesRead);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ping ping() throws IOException {
        int pingId;
        Ping ping = new Ping();
        SpdyConnection spdyConnection = this;
        synchronized (spdyConnection) {
            if (this.shutdown) {
                throw new IOException("shutdown");
            }
            pingId = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new HashMap<Integer, Ping>();
            }
            this.pings.put(pingId, ping);
        }
        this.writePing(false, pingId, 1330343787, ping);
        return ping;
    }

    private void writePingLater(final boolean reply, final int payload1, final int payload2, final Ping ping) {
        executor.execute(new NamedRunnable("OkHttp %s ping %08x%08x", new Object[]{this.hostName, payload1, payload2}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.writePing(reply, payload1, payload2, ping);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing(boolean reply, int payload1, int payload2, Ping ping) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            if (ping != null) {
                ping.send();
            }
            this.frameWriter.ping(reply, payload1, payload2);
        }
    }

    private synchronized Ping removePing(int id) {
        return this.pings != null ? this.pings.remove(id) : null;
    }

    public void flush() throws IOException {
        this.frameWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode statusCode) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int lastGoodStreamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
            }
            this.frameWriter.goAway(lastGoodStreamId, statusCode, Util.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ErrorCode connectionCode, ErrorCode streamCode) throws IOException {
        assert (!Thread.holdsLock(this));
        IOException thrown = null;
        try {
            this.shutdown(connectionCode);
        }
        catch (IOException e) {
            thrown = e;
        }
        SpdyStream[] streamsToClose = null;
        Ping[] pingsToCancel = null;
        SpdyStream[] spdyStreamArray = this;
        synchronized (this) {
            block19: {
                if (!this.streams.isEmpty()) {
                    streamsToClose = this.streams.values().toArray(new SpdyStream[this.streams.size()]);
                    this.streams.clear();
                    super.setIdle(false);
                }
                if (this.pings != null) {
                    pingsToCancel = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
                // ** MonitorExit[spdyStreamArray] (shouldn't be in output)
                if (streamsToClose != null) {
                    for (SpdyStream spdyStream : streamsToClose) {
                        try {
                            spdyStream.close(streamCode);
                        }
                        catch (IOException e) {
                            if (thrown == null) continue;
                            thrown = e;
                        }
                    }
                }
                if (pingsToCancel != null) {
                    for (SpdyStream spdyStream : pingsToCancel) {
                        ((Ping)((Object)spdyStream)).cancel();
                    }
                }
                try {
                    this.frameWriter.close();
                }
                catch (IOException e) {
                    if (thrown != null) break block19;
                    thrown = e;
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                thrown = e;
            }
            if (thrown != null) {
                throw thrown;
            }
            return;
        }
    }

    public void sendConnectionPreface() throws IOException {
        this.frameWriter.connectionPreface();
        this.frameWriter.settings(this.okHttpSettings);
        int windowSize = this.okHttpSettings.getInitialWindowSize(65536);
        if (windowSize != 65536) {
            this.frameWriter.windowUpdate(0, windowSize - 65536);
        }
    }

    private boolean pushedStream(int streamId) {
        return this.protocol == Protocol.HTTP_2 && streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushRequestLater(final int streamId, final List<Header> requestHeaders) {
        SpdyConnection spdyConnection = this;
        synchronized (spdyConnection) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block5: {
                    boolean cancel = SpdyConnection.this.pushObserver.onRequest(streamId, requestHeaders);
                    try {
                        if (!cancel) break block5;
                        SpdyConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        SpdyConnection spdyConnection = SpdyConnection.this;
                        synchronized (spdyConnection) {
                            SpdyConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushHeadersLater(final int streamId, final List<Header> requestHeaders, final boolean inFinished) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    boolean cancel = SpdyConnection.this.pushObserver.onHeaders(streamId, requestHeaders, inFinished);
                    try {
                        if (cancel) {
                            SpdyConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        SpdyConnection spdyConnection = SpdyConnection.this;
                        synchronized (spdyConnection) {
                            SpdyConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushDataLater(final int streamId, BufferedSource source, final int byteCount, final boolean inFinished) throws IOException {
        final Buffer buffer = new Buffer();
        source.require(byteCount);
        source.read(buffer, byteCount);
        if (buffer.size() != (long)byteCount) {
            throw new IOException(buffer.size() + " != " + byteCount);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    try {
                        boolean cancel = SpdyConnection.this.pushObserver.onData(streamId, buffer, byteCount, inFinished);
                        if (cancel) {
                            SpdyConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        SpdyConnection spdyConnection = SpdyConnection.this;
                        synchronized (spdyConnection) {
                            SpdyConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushResetLater(final int streamId, final ErrorCode errorCode) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                SpdyConnection.this.pushObserver.onReset(streamId, errorCode);
                SpdyConnection spdyConnection = SpdyConnection.this;
                synchronized (spdyConnection) {
                    SpdyConnection.this.currentPushRequests.remove(streamId);
                }
            }
        });
    }

    class Reader
    extends NamedRunnable
    implements FrameReader.Handler {
        FrameReader frameReader;

        private Reader() {
            super("OkHttp %s", SpdyConnection.this.hostName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            try {
                this.frameReader = SpdyConnection.this.variant.newReader(Okio.buffer(Okio.source(SpdyConnection.this.socket)), SpdyConnection.this.client);
                if (!SpdyConnection.this.client) {
                    this.frameReader.readConnectionPreface();
                }
                while (this.frameReader.nextFrame(this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                try {
                    SpdyConnection.this.close(connectionErrorCode, streamErrorCode);
                }
                catch (IOException iOException) {}
                Util.closeQuietly(this.frameReader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            if (SpdyConnection.this.pushedStream(streamId)) {
                SpdyConnection.this.pushDataLater(streamId, source, length, inFinished);
                return;
            }
            SpdyStream dataStream = SpdyConnection.this.getStream(streamId);
            if (dataStream == null) {
                SpdyConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                source.skip(length);
                return;
            }
            dataStream.receiveData(source, length);
            if (inFinished) {
                dataStream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            SpdyStream stream;
            if (SpdyConnection.this.pushedStream(streamId)) {
                SpdyConnection.this.pushHeadersLater(streamId, headerBlock, inFinished);
                return;
            }
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                if (SpdyConnection.this.shutdown) {
                    return;
                }
                stream = SpdyConnection.this.getStream(streamId);
                if (stream == null) {
                    if (headersMode.failIfStreamAbsent()) {
                        SpdyConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                        return;
                    }
                    if (streamId <= SpdyConnection.this.lastGoodStreamId) {
                        return;
                    }
                    if (streamId % 2 == SpdyConnection.this.nextStreamId % 2) {
                        return;
                    }
                    final SpdyStream newStream = new SpdyStream(streamId, SpdyConnection.this, outFinished, inFinished, headerBlock);
                    SpdyConnection.this.lastGoodStreamId = streamId;
                    SpdyConnection.this.streams.put(streamId, newStream);
                    executor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{SpdyConnection.this.hostName, streamId}){

                        @Override
                        public void execute() {
                            try {
                                SpdyConnection.this.handler.receive(newStream);
                            }
                            catch (IOException e) {
                                Internal.logger.log(Level.INFO, "StreamHandler failure for " + SpdyConnection.this.hostName, e);
                                try {
                                    newStream.close(ErrorCode.PROTOCOL_ERROR);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return;
                }
            }
            if (headersMode.failIfStreamPresent()) {
                stream.closeLater(ErrorCode.PROTOCOL_ERROR);
                SpdyConnection.this.removeStream(streamId);
                return;
            }
            stream.receiveHeaders(headerBlock, headersMode);
            if (inFinished) {
                stream.receiveFin();
            }
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            if (SpdyConnection.this.pushedStream(streamId)) {
                SpdyConnection.this.pushResetLater(streamId, errorCode);
                return;
            }
            SpdyStream rstStream = SpdyConnection.this.removeStream(streamId);
            if (rstStream != null) {
                rstStream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings newSettings) {
            long delta = 0L;
            SpdyStream[] streamsToNotify = null;
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                int peerInitialWindowSize;
                int priorWriteWindowSize = SpdyConnection.this.peerSettings.getInitialWindowSize(65536);
                if (clearPrevious) {
                    SpdyConnection.this.peerSettings.clear();
                }
                SpdyConnection.this.peerSettings.merge(newSettings);
                if (SpdyConnection.this.getProtocol() == Protocol.HTTP_2) {
                    this.ackSettingsLater(newSettings);
                }
                if ((peerInitialWindowSize = SpdyConnection.this.peerSettings.getInitialWindowSize(65536)) != -1 && peerInitialWindowSize != priorWriteWindowSize) {
                    delta = peerInitialWindowSize - priorWriteWindowSize;
                    if (!SpdyConnection.this.receivedInitialPeerSettings) {
                        SpdyConnection.this.addBytesToWriteWindow(delta);
                        SpdyConnection.this.receivedInitialPeerSettings = true;
                    }
                    if (!SpdyConnection.this.streams.isEmpty()) {
                        streamsToNotify = SpdyConnection.this.streams.values().toArray(new SpdyStream[SpdyConnection.this.streams.size()]);
                    }
                }
            }
            if (streamsToNotify != null && delta != 0L) {
                spdyConnection = streamsToNotify;
                int n = ((SpdyConnection)spdyConnection).length;
                for (int i = 0; i < n; ++i) {
                    SpdyConnection stream;
                    SpdyConnection spdyConnection2 = stream = spdyConnection[i];
                    synchronized (spdyConnection2) {
                        ((SpdyStream)((Object)stream)).addBytesToWriteWindow(delta);
                        continue;
                    }
                }
            }
        }

        private void ackSettingsLater(final Settings peerSettings) {
            executor.execute(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{SpdyConnection.this.hostName}){

                @Override
                public void execute() {
                    try {
                        SpdyConnection.this.frameWriter.ackSettings(peerSettings);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void ping(boolean reply, int payload1, int payload2) {
            if (reply) {
                Ping ping = SpdyConnection.this.removePing(payload1);
                if (ping != null) {
                    ping.receive();
                }
            } else {
                SpdyConnection.this.writePingLater(true, payload1, payload2, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            if (debugData.size() > 0) {
                // empty if block
            }
            SpdyStream[] spdyStreamArray = SpdyConnection.this;
            synchronized (SpdyConnection.this) {
                SpdyStream[] streamsCopy = SpdyConnection.this.streams.values().toArray(new SpdyStream[SpdyConnection.this.streams.size()]);
                SpdyConnection.this.shutdown = true;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                for (SpdyStream spdyStream : streamsCopy) {
                    if (spdyStream.getId() <= lastGoodStreamId || !spdyStream.isLocallyInitiated()) continue;
                    spdyStream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    SpdyConnection.this.removeStream(spdyStream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                SpdyConnection spdyConnection = SpdyConnection.this;
                synchronized (spdyConnection) {
                    SpdyConnection.this.bytesLeftInWriteWindow += windowSizeIncrement;
                    SpdyConnection.this.notifyAll();
                }
            }
            SpdyStream stream = SpdyConnection.this.getStream(streamId);
            if (stream != null) {
                SpdyStream spdyStream = stream;
                synchronized (spdyStream) {
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
            SpdyConnection.this.pushRequestLater(promisedStreamId, requestHeaders);
        }

        @Override
        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }

    public static class Builder {
        private String hostName;
        private Socket socket;
        private IncomingStreamHandler handler = IncomingStreamHandler.REFUSE_INCOMING_STREAMS;
        private Protocol protocol = Protocol.SPDY_3;
        private PushObserver pushObserver = PushObserver.CANCEL;
        private boolean client;

        public Builder(boolean client, Socket socket) throws IOException {
            this(((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), client, socket);
        }

        public Builder(String hostName, boolean client, Socket socket) throws IOException {
            this.hostName = hostName;
            this.client = client;
            this.socket = socket;
        }

        public Builder handler(IncomingStreamHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public SpdyConnection build() throws IOException {
            return new SpdyConnection(this);
        }
    }
}

