/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.interpol;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.jexl.Expression;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.jexl.ExpressionFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.jexl.JexlContext;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.jexl.JexlHelper;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.lang.ClassUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.lang.text.StrLookup;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.lang.text.StrSubstitutor;

public class ExprLookup
extends StrLookup {
    private static final String CLASS = "Class:";
    private static final String DEFAULT_PREFIX = "$[";
    private static final String DEFAULT_SUFFIX = "]";
    private AbstractConfiguration configuration;
    private JexlContext context = JexlHelper.createContext();
    private String prefixMatcher = "$[";
    private String suffixMatcher = "]";

    public ExprLookup() {
    }

    public ExprLookup(Variables list) {
        this.setVariables(list);
    }

    public ExprLookup(Variables list, String prefix, String suffix) {
        this(list);
        this.setVariablePrefixMatcher(prefix);
        this.setVariableSuffixMatcher(suffix);
    }

    public void setVariablePrefixMatcher(String prefix) {
        this.prefixMatcher = prefix;
    }

    public void setVariableSuffixMatcher(String suffix) {
        this.suffixMatcher = suffix;
    }

    public void setVariables(Variables list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            this.context.getVars().put(var.getName(), var.getValue());
        }
    }

    public Variables getVariables() {
        return null;
    }

    public void setConfiguration(AbstractConfiguration config) {
        this.configuration = config;
    }

    public String lookup(String var) {
        ConfigurationInterpolator interp = this.configuration.getInterpolator();
        StrSubstitutor subst = new StrSubstitutor((StrLookup)interp, this.prefixMatcher, this.suffixMatcher, '$');
        String result = subst.replace(var);
        try {
            Expression exp = ExpressionFactory.createExpression((String)result);
            result = (String)exp.evaluate(this.context);
        }
        catch (Exception e) {
            this.configuration.getLogger().debug("Error encountered evaluating " + result, e);
        }
        return result;
    }

    public static class Variable {
        private String key;
        private Object value;

        public Variable() {
        }

        public Variable(String name, Object value) {
            this.setName(name);
            this.setValue(value);
        }

        public String getName() {
            return this.key;
        }

        public void setName(String name) {
            this.key = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) throws ConfigurationRuntimeException {
            try {
                if (!(value instanceof String)) {
                    this.value = value;
                    return;
                }
                String val = (String)value;
                String name = StringUtils.removeStartIgnoreCase(val, ExprLookup.CLASS);
                Class clazz = ClassUtils.getClass(name);
                this.value = name.length() == val.length() ? clazz.newInstance() : clazz;
            }
            catch (Exception e) {
                throw new ConfigurationRuntimeException("Unable to create " + value, e);
            }
        }
    }

    public static class Variables
    extends ArrayList {
        public Variable getVariable() {
            if (this.size() > 0) {
                return (Variable)this.get(this.size() - 1);
            }
            return null;
        }
    }
}

