/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.linear;

import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.exception.util.Localizable;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.linear.MatrixUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.linear.RealMatrix;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.linear.RealVector;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.util.FastMath;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.math3.util.Precision;

public class SingularValueDecomposition {
    private static final double EPS = 2.220446049250313E-16;
    private static final double TINY = 1.6033346880071782E-291;
    private final double[] singularValues;
    private final int m;
    private final int n;
    private final boolean transposed;
    private final RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private final RealMatrix cachedV;
    private RealMatrix cachedVt;
    private final double tol;

    public SingularValueDecomposition(RealMatrix matrix) {
        int i;
        double t;
        int j;
        int k;
        int i2;
        int i3;
        int j2;
        double[][] A;
        if (matrix.getRowDimension() < matrix.getColumnDimension()) {
            this.transposed = true;
            A = matrix.transpose().getData();
            this.m = matrix.getColumnDimension();
            this.n = matrix.getRowDimension();
        } else {
            this.transposed = false;
            A = matrix.getData();
            this.m = matrix.getRowDimension();
            this.n = matrix.getColumnDimension();
        }
        this.singularValues = new double[this.n];
        double[][] U = new double[this.m][this.n];
        double[][] V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        int nct = FastMath.min(this.m - 1, this.n);
        int nrt = FastMath.max(0, this.n - 2);
        for (int k2 = 0; k2 < FastMath.max(nct, nrt); ++k2) {
            double t2;
            int i4;
            if (k2 < nct) {
                this.singularValues[k2] = 0.0;
                for (i4 = k2; i4 < this.m; ++i4) {
                    this.singularValues[k2] = FastMath.hypot(this.singularValues[k2], A[i4][k2]);
                }
                if (this.singularValues[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        this.singularValues[k2] = -this.singularValues[k2];
                    }
                    for (i4 = k2; i4 < this.m; ++i4) {
                        double[] dArray = A[i4];
                        int n = k2;
                        dArray[n] = dArray[n] / this.singularValues[k2];
                    }
                    double[] dArray = A[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.singularValues[k2] = -this.singularValues[k2];
            }
            for (j2 = k2 + 1; j2 < this.n; ++j2) {
                if (k2 < nct && this.singularValues[k2] != 0.0) {
                    t2 = 0.0;
                    for (i3 = k2; i3 < this.m; ++i3) {
                        t2 += A[i3][k2] * A[i3][j2];
                    }
                    t2 = -t2 / A[k2][k2];
                    for (i3 = k2; i3 < this.m; ++i3) {
                        double[] dArray = A[i3];
                        int n = j2;
                        dArray[n] = dArray[n] + t2 * A[i3][k2];
                    }
                }
                e[j2] = A[k2][j2];
            }
            if (k2 < nct) {
                for (i4 = k2; i4 < this.m; ++i4) {
                    U[i4][k2] = A[i4][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0;
            for (i4 = k2 + 1; i4 < this.n; ++i4) {
                e[k2] = FastMath.hypot(e[k2], e[i4]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i4 = k2 + 1;
                while (i4 < this.n) {
                    int n = i4++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this.m && e[k2] != 0.0) {
                for (i4 = k2 + 1; i4 < this.m; ++i4) {
                    work[i4] = 0.0;
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    for (i2 = k2 + 1; i2 < this.m; ++i2) {
                        int n = i2;
                        work[n] = work[n] + e[j2] * A[i2][j2];
                    }
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    t2 = -e[j2] / e[k2 + 1];
                    for (i3 = k2 + 1; i3 < this.m; ++i3) {
                        double[] dArray = A[i3];
                        int n = j2;
                        dArray[n] = dArray[n] + t2 * work[i3];
                    }
                }
            }
            for (i4 = k2 + 1; i4 < this.n; ++i4) {
                V[i4][k2] = e[i4];
            }
        }
        int p = this.n;
        if (nct < this.n) {
            this.singularValues[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.singularValues[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        for (j2 = nct; j2 < this.n; ++j2) {
            for (i2 = 0; i2 < this.m; ++i2) {
                U[i2][j2] = 0.0;
            }
            U[j2][j2] = 1.0;
        }
        for (k = nct - 1; k >= 0; --k) {
            if (this.singularValues[k] != 0.0) {
                for (j = k + 1; j < this.n; ++j) {
                    t = 0.0;
                    for (i = k; i < this.m; ++i) {
                        t += U[i][k] * U[i][j];
                    }
                    t = -t / U[k][k];
                    for (i = k; i < this.m; ++i) {
                        double[] dArray = U[i];
                        int n = j;
                        dArray[n] = dArray[n] + t * U[i][k];
                    }
                }
                for (i2 = k; i2 < this.m; ++i2) {
                    U[i2][k] = -U[i2][k];
                }
                U[k][k] = 1.0 + U[k][k];
                for (i2 = 0; i2 < k - 1; ++i2) {
                    U[i2][k] = 0.0;
                }
                continue;
            }
            for (i2 = 0; i2 < this.m; ++i2) {
                U[i2][k] = 0.0;
            }
            U[k][k] = 1.0;
        }
        for (k = this.n - 1; k >= 0; --k) {
            if (k < nrt && e[k] != 0.0) {
                for (j = k + 1; j < this.n; ++j) {
                    t = 0.0;
                    for (i = k + 1; i < this.n; ++i) {
                        t += V[i][k] * V[i][j];
                    }
                    t = -t / V[k + 1][k];
                    for (i = k + 1; i < this.n; ++i) {
                        double[] dArray = V[i];
                        int n = j;
                        dArray[n] = dArray[n] + t * V[i][k];
                    }
                }
            }
            for (i2 = 0; i2 < this.n; ++i2) {
                V[i2][k] = 0.0;
            }
            V[k][k] = 1.0;
        }
        int pp = p - 1;
        block34: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= 0; --k3) {
                double threshold = 1.6033346880071782E-291 + 2.220446049250313E-16 * (FastMath.abs(this.singularValues[k3]) + FastMath.abs(this.singularValues[k3 + 1]));
                if (FastMath.abs(e[k3]) > threshold) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t3 = (ks != p ? FastMath.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? FastMath.abs(e[ks - 1]) : 0.0);
                    if (!(FastMath.abs(this.singularValues[ks]) <= 1.6033346880071782E-291 + 2.220446049250313E-16 * t3)) continue;
                    this.singularValues[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i5;
                    double sn;
                    double cs;
                    double t4;
                    int j3;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (j3 = p - 2; j3 >= k3; --j3) {
                        t4 = FastMath.hypot(this.singularValues[j3], f);
                        cs = this.singularValues[j3] / t4;
                        sn = f / t4;
                        this.singularValues[j3] = t4;
                        if (j3 != k3) {
                            f = -sn * e[j3 - 1];
                            e[j3 - 1] = cs * e[j3 - 1];
                        }
                        for (i5 = 0; i5 < this.n; ++i5) {
                            t4 = cs * V[i5][j3] + sn * V[i5][p - 1];
                            V[i5][p - 1] = -sn * V[i5][j3] + cs * V[i5][p - 1];
                            V[i5][j3] = t4;
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int i5;
                    double sn;
                    double cs;
                    double t4;
                    int j3;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (j3 = k3; j3 < p; ++j3) {
                        t4 = FastMath.hypot(this.singularValues[j3], f);
                        cs = this.singularValues[j3] / t4;
                        sn = f / t4;
                        this.singularValues[j3] = t4;
                        f = -sn * e[j3];
                        e[j3] = cs * e[j3];
                        for (i5 = 0; i5 < this.m; ++i5) {
                            t4 = cs * U[i5][j3] + sn * U[i5][k3 - 1];
                            U[i5][k3 - 1] = -sn * U[i5][j3] + cs * U[i5][k3 - 1];
                            U[i5][j3] = t4;
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double maxPm1Pm2 = FastMath.max(FastMath.abs(this.singularValues[p - 1]), FastMath.abs(this.singularValues[p - 2]));
                    double scale = FastMath.max(FastMath.max(FastMath.max(maxPm1Pm2, FastMath.abs(e[p - 2])), FastMath.abs(this.singularValues[k3])), FastMath.abs(e[k3]));
                    double sp = this.singularValues[p - 1] / scale;
                    double spm1 = this.singularValues[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.singularValues[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = FastMath.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j4 = k3; j4 < p - 1; ++j4) {
                        int i6;
                        double t5 = FastMath.hypot(f, g);
                        double cs = f / t5;
                        double sn = g / t5;
                        if (j4 != k3) {
                            e[j4 - 1] = t5;
                        }
                        f = cs * this.singularValues[j4] + sn * e[j4];
                        e[j4] = cs * e[j4] - sn * this.singularValues[j4];
                        g = sn * this.singularValues[j4 + 1];
                        this.singularValues[j4 + 1] = cs * this.singularValues[j4 + 1];
                        for (i6 = 0; i6 < this.n; ++i6) {
                            t5 = cs * V[i6][j4] + sn * V[i6][j4 + 1];
                            V[i6][j4 + 1] = -sn * V[i6][j4] + cs * V[i6][j4 + 1];
                            V[i6][j4] = t5;
                        }
                        t5 = FastMath.hypot(f, g);
                        cs = f / t5;
                        sn = g / t5;
                        this.singularValues[j4] = t5;
                        f = cs * e[j4] + sn * this.singularValues[j4 + 1];
                        this.singularValues[j4 + 1] = -sn * e[j4] + cs * this.singularValues[j4 + 1];
                        g = sn * e[j4 + 1];
                        e[j4 + 1] = cs * e[j4 + 1];
                        if (j4 >= this.m - 1) continue;
                        for (i6 = 0; i6 < this.m; ++i6) {
                            t5 = cs * U[i6][j4] + sn * U[i6][j4 + 1];
                            U[i6][j4 + 1] = -sn * U[i6][j4] + cs * U[i6][j4 + 1];
                            U[i6][j4] = t5;
                        }
                    }
                    e[p - 2] = f;
                    break;
                }
                default: {
                    if (this.singularValues[k3] <= 0.0) {
                        this.singularValues[k3] = this.singularValues[k3] < 0.0 ? -this.singularValues[k3] : 0.0;
                        for (i3 = 0; i3 <= pp; ++i3) {
                            V[i3][k3] = -V[i3][k3];
                        }
                    }
                    while (k3 < pp && !(this.singularValues[k3] >= this.singularValues[k3 + 1])) {
                        int i7;
                        double t6 = this.singularValues[k3];
                        this.singularValues[k3] = this.singularValues[k3 + 1];
                        this.singularValues[k3 + 1] = t6;
                        if (k3 < this.n - 1) {
                            for (i7 = 0; i7 < this.n; ++i7) {
                                t6 = V[i7][k3 + 1];
                                V[i7][k3 + 1] = V[i7][k3];
                                V[i7][k3] = t6;
                            }
                        }
                        if (k3 < this.m - 1) {
                            for (i7 = 0; i7 < this.m; ++i7) {
                                t6 = U[i7][k3 + 1];
                                U[i7][k3 + 1] = U[i7][k3];
                                U[i7][k3] = t6;
                            }
                        }
                        ++k3;
                    }
                    --p;
                }
            }
        }
        this.tol = FastMath.max((double)this.m * this.singularValues[0] * 2.220446049250313E-16, FastMath.sqrt(Precision.SAFE_MIN));
        if (!this.transposed) {
            this.cachedU = MatrixUtils.createRealMatrix(U);
            this.cachedV = MatrixUtils.createRealMatrix(V);
        } else {
            this.cachedU = MatrixUtils.createRealMatrix(V);
            this.cachedV = MatrixUtils.createRealMatrix(U);
        }
    }

    public RealMatrix getU() {
        return this.cachedU;
    }

    public RealMatrix getUT() {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    public RealMatrix getS() {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    public double[] getSingularValues() {
        return (double[])this.singularValues.clone();
    }

    public RealMatrix getV() {
        return this.cachedV;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    public RealMatrix getCovariance(double minSingularValue) {
        int dimension;
        int p = this.singularValues.length;
        for (dimension = 0; dimension < p && this.singularValues[dimension] >= minSingularValue; ++dimension) {
        }
        if (dimension == 0) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, (Number)minSingularValue, this.singularValues[0], true);
        }
        final double[][] data = new double[dimension][p];
        this.getVT().walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                data[row][column] = value / SingularValueDecomposition.this.singularValues[row];
            }
        }, 0, dimension - 1, 0, p - 1);
        Array2DRowRealMatrix jv = new Array2DRowRealMatrix(data, false);
        return jv.transpose().multiply(jv);
    }

    public double getNorm() {
        return this.singularValues[0];
    }

    public double getConditionNumber() {
        return this.singularValues[0] / this.singularValues[this.n - 1];
    }

    public double getInverseConditionNumber() {
        return this.singularValues[this.n - 1] / this.singularValues[0];
    }

    public int getRank() {
        int r = 0;
        for (int i = 0; i < this.singularValues.length; ++i) {
            if (!(this.singularValues[i] > this.tol)) continue;
            ++r;
        }
        return r;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == this.m, this.tol);
    }

    private static class Solver
    implements DecompositionSolver {
        private final RealMatrix pseudoInverse;
        private boolean nonSingular;

        private Solver(double[] singularValues, RealMatrix uT, RealMatrix v, boolean nonSingular, double tol) {
            double[][] suT = uT.getData();
            for (int i = 0; i < singularValues.length; ++i) {
                double a = singularValues[i] > tol ? 1.0 / singularValues[i] : 0.0;
                double[] suTi = suT[i];
                int j = 0;
                while (j < suTi.length) {
                    int n = j++;
                    suTi[n] = suTi[n] * a;
                }
            }
            this.pseudoInverse = v.multiply(new Array2DRowRealMatrix(suT, false));
            this.nonSingular = nonSingular;
        }

        public RealVector solve(RealVector b) {
            return this.pseudoInverse.operate(b);
        }

        public RealMatrix solve(RealMatrix b) {
            return this.pseudoInverse.multiply(b);
        }

        public boolean isNonSingular() {
            return this.nonSingular;
        }

        public RealMatrix getInverse() {
            return this.pseudoInverse;
        }
    }
}

