/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.KeyProvider;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class KeyProviderFactory {
    public static final String KEY_PROVIDER_PATH = "hadoop.security.key.provider.path";
    private static final ServiceLoader<KeyProviderFactory> serviceLoader = ServiceLoader.load(KeyProviderFactory.class, KeyProviderFactory.class.getClassLoader());

    public abstract KeyProvider createProvider(URI var1, Configuration var2) throws IOException;

    public static List<KeyProvider> getProviders(Configuration conf) throws IOException {
        ArrayList<KeyProvider> result = new ArrayList<KeyProvider>();
        for (String path : conf.getStringCollection(KEY_PROVIDER_PATH)) {
            try {
                URI uri = new URI(path);
                KeyProvider kp = KeyProviderFactory.get(uri, conf);
                if (kp != null) {
                    result.add(kp);
                    continue;
                }
                throw new IOException("No KeyProviderFactory for " + uri + " in " + KEY_PROVIDER_PATH);
            }
            catch (URISyntaxException error) {
                throw new IOException("Bad configuration of hadoop.security.key.provider.path at " + path, error);
            }
        }
        return result;
    }

    public static KeyProvider get(URI uri, Configuration conf) throws IOException {
        KeyProviderFactory factory;
        KeyProvider kp = null;
        Iterator<KeyProviderFactory> iterator = serviceLoader.iterator();
        while (iterator.hasNext() && (kp = (factory = iterator.next()).createProvider(uri, conf)) == null) {
        }
        return kp;
    }

    static {
        Iterator<KeyProviderFactory> iterServices = serviceLoader.iterator();
        while (iterServices.hasNext()) {
            iterServices.next();
        }
    }
}

