/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.kms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.KeyProviderDelegationTokenExtension;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.Credentials;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancingKMSClientProvider
extends KeyProvider
implements KeyProviderCryptoExtension.CryptoExtension,
KeyProviderDelegationTokenExtension.DelegationTokenExtension {
    public static Logger LOG = LoggerFactory.getLogger(LoadBalancingKMSClientProvider.class);
    private final KMSClientProvider[] providers;
    private final AtomicInteger currentIdx;

    public LoadBalancingKMSClientProvider(KMSClientProvider[] providers, Configuration conf) {
        this(LoadBalancingKMSClientProvider.shuffle(providers), Time.monotonicNow(), conf);
    }

    @VisibleForTesting
    LoadBalancingKMSClientProvider(KMSClientProvider[] providers, long seed, Configuration conf) {
        super(conf);
        this.providers = providers;
        this.currentIdx = new AtomicInteger((int)(seed % (long)providers.length));
    }

    @VisibleForTesting
    KMSClientProvider[] getProviders() {
        return this.providers;
    }

    private <T> T doOp(ProviderCallable<T> op, int currPos) throws IOException {
        IOException ex = null;
        for (int i = 0; i < this.providers.length; ++i) {
            KMSClientProvider provider = this.providers[(currPos + i) % this.providers.length];
            try {
                return op.call(provider);
            }
            catch (IOException ioe) {
                LOG.warn("KMS provider at [{}] threw an IOException [{}]!!", (Object)provider.getKMSUrl(), (Object)ioe.getMessage());
                ex = ioe;
                continue;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new WrapperException(e);
            }
        }
        if (ex != null) {
            LOG.warn("Aborting since the Request has failed with all KMS providers in the group. !!");
            throw ex;
        }
        throw new IOException("No providers configured !!");
    }

    private int nextIdx() {
        int next;
        int current;
        while (!this.currentIdx.compareAndSet(current = this.currentIdx.get(), next = (current + 1) % this.providers.length)) {
        }
        return current;
    }

    @Override
    public Token<?>[] addDelegationTokens(final String renewer, final Credentials credentials) throws IOException {
        return this.doOp(new ProviderCallable<Token<?>[]>(){

            @Override
            public Token<?>[] call(KMSClientProvider provider) throws IOException {
                return provider.addDelegationTokens(renewer, credentials);
            }
        }, this.nextIdx());
    }

    @Override
    public long renewDelegationToken(final Token<?> token) throws IOException {
        return this.doOp(new ProviderCallable<Long>(){

            @Override
            public Long call(KMSClientProvider provider) throws IOException {
                return provider.renewDelegationToken(token);
            }
        }, this.nextIdx());
    }

    @Override
    public Void cancelDelegationToken(final Token<?> token) throws IOException {
        return this.doOp(new ProviderCallable<Void>(){

            @Override
            public Void call(KMSClientProvider provider) throws IOException {
                provider.cancelDelegationToken(token);
                return null;
            }
        }, this.nextIdx());
    }

    @Override
    public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        for (KMSClientProvider provider : this.providers) {
            try {
                provider.warmUpEncryptedKeys(keyNames);
            }
            catch (IOException ioe) {
                LOG.error("Error warming up keys for provider with url[" + provider.getKMSUrl() + "]");
            }
        }
    }

    @Override
    public void drain(String keyName) {
        for (KMSClientProvider provider : this.providers) {
            provider.drain(keyName);
        }
    }

    @Override
    public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(final String encryptionKeyName) throws IOException, GeneralSecurityException {
        try {
            return this.doOp(new ProviderCallable<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

                @Override
                public KeyProviderCryptoExtension.EncryptedKeyVersion call(KMSClientProvider provider) throws IOException, GeneralSecurityException {
                    return provider.generateEncryptedKey(encryptionKeyName);
                }
            }, this.nextIdx());
        }
        catch (WrapperException we) {
            if (we.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)we.getCause();
            }
            throw new IOException(we.getCause());
        }
    }

    @Override
    public KeyProvider.KeyVersion decryptEncryptedKey(final KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
        try {
            return this.doOp(new ProviderCallable<KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion call(KMSClientProvider provider) throws IOException, GeneralSecurityException {
                    return provider.decryptEncryptedKey(encryptedKeyVersion);
                }
            }, this.nextIdx());
        }
        catch (WrapperException we) {
            if (we.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)we.getCause();
            }
            throw new IOException(we.getCause());
        }
    }

    @Override
    public KeyProvider.KeyVersion getKeyVersion(final String versionName) throws IOException {
        return this.doOp(new ProviderCallable<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion call(KMSClientProvider provider) throws IOException {
                return provider.getKeyVersion(versionName);
            }
        }, this.nextIdx());
    }

    @Override
    public List<String> getKeys() throws IOException {
        return this.doOp(new ProviderCallable<List<String>>(){

            @Override
            public List<String> call(KMSClientProvider provider) throws IOException {
                return provider.getKeys();
            }
        }, this.nextIdx());
    }

    @Override
    public KeyProvider.Metadata[] getKeysMetadata(final String ... names) throws IOException {
        return this.doOp(new ProviderCallable<KeyProvider.Metadata[]>(){

            @Override
            public KeyProvider.Metadata[] call(KMSClientProvider provider) throws IOException {
                return provider.getKeysMetadata(names);
            }
        }, this.nextIdx());
    }

    @Override
    public List<KeyProvider.KeyVersion> getKeyVersions(final String name) throws IOException {
        return this.doOp(new ProviderCallable<List<KeyProvider.KeyVersion>>(){

            @Override
            public List<KeyProvider.KeyVersion> call(KMSClientProvider provider) throws IOException {
                return provider.getKeyVersions(name);
            }
        }, this.nextIdx());
    }

    @Override
    public KeyProvider.KeyVersion getCurrentKey(final String name) throws IOException {
        return this.doOp(new ProviderCallable<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion call(KMSClientProvider provider) throws IOException {
                return provider.getCurrentKey(name);
            }
        }, this.nextIdx());
    }

    @Override
    public KeyProvider.Metadata getMetadata(final String name) throws IOException {
        return this.doOp(new ProviderCallable<KeyProvider.Metadata>(){

            @Override
            public KeyProvider.Metadata call(KMSClientProvider provider) throws IOException {
                return provider.getMetadata(name);
            }
        }, this.nextIdx());
    }

    @Override
    public KeyProvider.KeyVersion createKey(final String name, final byte[] material, final KeyProvider.Options options) throws IOException {
        return this.doOp(new ProviderCallable<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion call(KMSClientProvider provider) throws IOException {
                return provider.createKey(name, material, options);
            }
        }, this.nextIdx());
    }

    @Override
    public KeyProvider.KeyVersion createKey(final String name, final KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
        try {
            return this.doOp(new ProviderCallable<KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion call(KMSClientProvider provider) throws IOException, NoSuchAlgorithmException {
                    return provider.createKey(name, options);
                }
            }, this.nextIdx());
        }
        catch (WrapperException e) {
            if (e.getCause() instanceof GeneralSecurityException) {
                throw (NoSuchAlgorithmException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void deleteKey(final String name) throws IOException {
        this.doOp(new ProviderCallable<Void>(){

            @Override
            public Void call(KMSClientProvider provider) throws IOException {
                provider.deleteKey(name);
                return null;
            }
        }, this.nextIdx());
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(final String name, final byte[] material) throws IOException {
        return this.doOp(new ProviderCallable<KeyProvider.KeyVersion>(){

            @Override
            public KeyProvider.KeyVersion call(KMSClientProvider provider) throws IOException {
                return provider.rollNewVersion(name, material);
            }
        }, this.nextIdx());
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(final String name) throws NoSuchAlgorithmException, IOException {
        try {
            return this.doOp(new ProviderCallable<KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion call(KMSClientProvider provider) throws IOException, NoSuchAlgorithmException {
                    return provider.rollNewVersion(name);
                }
            }, this.nextIdx());
        }
        catch (WrapperException e) {
            if (e.getCause() instanceof GeneralSecurityException) {
                throw (NoSuchAlgorithmException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void close() throws IOException {
        for (KMSClientProvider provider : this.providers) {
            try {
                provider.close();
            }
            catch (IOException ioe) {
                LOG.error("Error closing provider with url[" + provider.getKMSUrl() + "]");
            }
        }
    }

    @Override
    public void flush() throws IOException {
        for (KMSClientProvider provider : this.providers) {
            try {
                provider.flush();
            }
            catch (IOException ioe) {
                LOG.error("Error flushing provider with url[" + provider.getKMSUrl() + "]");
            }
        }
    }

    private static KMSClientProvider[] shuffle(KMSClientProvider[] providers) {
        List<KMSClientProvider> list = Arrays.asList(providers);
        Collections.shuffle(list);
        return list.toArray(providers);
    }

    static class WrapperException
    extends RuntimeException {
        public WrapperException(Throwable cause) {
            super(cause);
        }
    }

    static interface ProviderCallable<T> {
        public T call(KMSClientProvider var1) throws IOException, Exception;
    }
}

