/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.protocolPB;

import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.com.google.protobuf.RpcController;
import org.apache.flink.fs.s3hadoop.shaded.com.google.protobuf.ServiceException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.HAServiceStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.RPC;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HAServiceProtocolServerSideTranslatorPB
implements HAServiceProtocolPB {
    private final HAServiceProtocol server;
    private static final HAServiceProtocolProtos.MonitorHealthResponseProto MONITOR_HEALTH_RESP = HAServiceProtocolProtos.MonitorHealthResponseProto.newBuilder().build();
    private static final HAServiceProtocolProtos.TransitionToActiveResponseProto TRANSITION_TO_ACTIVE_RESP = HAServiceProtocolProtos.TransitionToActiveResponseProto.newBuilder().build();
    private static final HAServiceProtocolProtos.TransitionToStandbyResponseProto TRANSITION_TO_STANDBY_RESP = HAServiceProtocolProtos.TransitionToStandbyResponseProto.newBuilder().build();
    private static final Log LOG = LogFactory.getLog(HAServiceProtocolServerSideTranslatorPB.class);

    public HAServiceProtocolServerSideTranslatorPB(HAServiceProtocol server) {
        this.server = server;
    }

    @Override
    public HAServiceProtocolProtos.MonitorHealthResponseProto monitorHealth(RpcController controller, HAServiceProtocolProtos.MonitorHealthRequestProto request) throws ServiceException {
        try {
            this.server.monitorHealth();
            return MONITOR_HEALTH_RESP;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    private HAServiceProtocol.StateChangeRequestInfo convert(HAServiceProtocolProtos.HAStateChangeRequestInfoProto proto) {
        HAServiceProtocol.RequestSource src;
        switch (proto.getReqSource()) {
            case REQUEST_BY_USER: {
                src = HAServiceProtocol.RequestSource.REQUEST_BY_USER;
                break;
            }
            case REQUEST_BY_USER_FORCED: {
                src = HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED;
                break;
            }
            case REQUEST_BY_ZKFC: {
                src = HAServiceProtocol.RequestSource.REQUEST_BY_ZKFC;
                break;
            }
            default: {
                LOG.warn("Unknown request source: " + proto.getReqSource());
                src = null;
            }
        }
        return new HAServiceProtocol.StateChangeRequestInfo(src);
    }

    @Override
    public HAServiceProtocolProtos.TransitionToActiveResponseProto transitionToActive(RpcController controller, HAServiceProtocolProtos.TransitionToActiveRequestProto request) throws ServiceException {
        try {
            this.server.transitionToActive(this.convert(request.getReqInfo()));
            return TRANSITION_TO_ACTIVE_RESP;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public HAServiceProtocolProtos.TransitionToStandbyResponseProto transitionToStandby(RpcController controller, HAServiceProtocolProtos.TransitionToStandbyRequestProto request) throws ServiceException {
        try {
            this.server.transitionToStandby(this.convert(request.getReqInfo()));
            return TRANSITION_TO_STANDBY_RESP;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public HAServiceProtocolProtos.GetServiceStatusResponseProto getServiceStatus(RpcController controller, HAServiceProtocolProtos.GetServiceStatusRequestProto request) throws ServiceException {
        HAServiceProtocolProtos.HAServiceStateProto retState;
        HAServiceStatus s;
        try {
            s = this.server.getServiceStatus();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        switch (s.getState()) {
            case ACTIVE: {
                retState = HAServiceProtocolProtos.HAServiceStateProto.ACTIVE;
                break;
            }
            case STANDBY: {
                retState = HAServiceProtocolProtos.HAServiceStateProto.STANDBY;
                break;
            }
            default: {
                retState = HAServiceProtocolProtos.HAServiceStateProto.INITIALIZING;
            }
        }
        HAServiceProtocolProtos.GetServiceStatusResponseProto.Builder ret = HAServiceProtocolProtos.GetServiceStatusResponseProto.newBuilder().setState(retState).setReadyToBecomeActive(s.isReadyToBecomeActive());
        if (!s.isReadyToBecomeActive()) {
            ret.setNotReadyReason(s.getNotReadyReason());
        }
        return ret.build();
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        return RPC.getProtocolVersion(HAServiceProtocolPB.class);
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        if (!protocol.equals(RPC.getProtocolName(HAServiceProtocolPB.class))) {
            throw new IOException("Serverside implements " + RPC.getProtocolName(HAServiceProtocolPB.class) + ". The following requested protocol is unknown: " + protocol);
        }
        return ProtocolSignature.getProtocolSignature(clientMethodsHash, RPC.getProtocolVersion(HAServiceProtocolPB.class), HAServiceProtocolPB.class);
    }
}

