/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.client;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHealthy(URI uri) {
        boolean bl;
        String scheme = uri.getScheme();
        if (!"hdfs".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("The scheme is not hdfs, uri=" + uri);
        }
        Configuration conf = new Configuration();
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", scheme), true);
        conf.setBoolean("dfs.client.retry.policy.enabled", false);
        conf.setInt("ipc.client.connect.max.retries", 0);
        DistributedFileSystem fs = null;
        try {
            fs = (DistributedFileSystem)FileSystem.get(uri, conf);
            boolean safemode = fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Is namenode in safemode? " + safemode + "; uri=" + uri);
            }
            fs.close();
            fs = null;
            bl = !safemode;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got an exception for uri=" + uri, (Throwable)e);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
            IOUtils.closeQuietly(fs);
            return bl2;
        }
        IOUtils.closeQuietly(fs);
        return bl;
    }
}

