/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.net.Peer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.net.unix.DomainSocket;

public class BasicInetPeer
implements Peer {
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;
    private final boolean isLocal;

    public BasicInetPeer(Socket socket) throws IOException {
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.isLocal = socket.getInetAddress().equals(socket.getLocalAddress());
    }

    @Override
    public ReadableByteChannel getInputStreamChannel() {
        return null;
    }

    @Override
    public void setReadTimeout(int timeoutMs) throws IOException {
        this.socket.setSoTimeout(timeoutMs);
    }

    @Override
    public int getReceiveBufferSize() throws IOException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public boolean getTcpNoDelay() throws IOException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public void setWriteTimeout(int timeoutMs) {
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public String getRemoteAddressString() {
        return this.socket.getRemoteSocketAddress().toString();
    }

    @Override
    public String getLocalAddressString() {
        return this.socket.getLocalSocketAddress().toString();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    public String toString() {
        return "BasicInetPeer(" + this.socket.toString() + ")";
    }

    @Override
    public DomainSocket getDomainSocket() {
        return null;
    }

    @Override
    public boolean hasSecureChannel() {
        return false;
    }
}

