/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.security.token.delegation;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Charsets;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.net.NetUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.Credentials;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.SecurityUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DelegationUtilsClient {
    public static final Logger LOG = LoggerFactory.getLogger(DelegationUtilsClient.class);
    public static final String STARTUP_PROGRESS_PATH_SPEC = "/startupProgress";
    public static final String GET_DELEGATION_TOKEN_PATH_SPEC = "/getDelegationToken";
    public static final String RENEW_DELEGATION_TOKEN_PATH_SPEC = "/renewDelegationToken";
    public static final String CANCEL_DELEGATION_TOKEN_PATH_SPEC = "/cancelDelegationToken";
    public static final String TOKEN = "token";
    public static final String RENEWER = "renewer";
    public static final String DELEGATION_PARAMETER_NAME = "delegation";
    private static final String SET_DELEGATION = "&delegation=";

    public static Credentials getDTfromRemote(URLConnectionFactory factory, URI nnUri, String renewer, String proxyUser) throws IOException {
        Credentials credentials;
        StringBuilder buf = new StringBuilder(nnUri.toString()).append(GET_DELEGATION_TOKEN_PATH_SPEC);
        String separator = "?";
        if (renewer != null) {
            buf.append("?").append(RENEWER).append("=").append(renewer);
            separator = "&";
        }
        if (proxyUser != null) {
            buf.append(separator).append("doas=").append(proxyUser);
        }
        boolean isHttps = nnUri.getScheme().equals("https");
        HttpURLConnection conn = null;
        DataInputStream dis = null;
        InetSocketAddress serviceAddr = NetUtils.createSocketAddr(nnUri.getAuthority());
        try {
            LOG.debug("Retrieving token from: {}", (Object)buf);
            conn = DelegationUtilsClient.run(factory, new URL(buf.toString()));
            InputStream in = conn.getInputStream();
            Credentials ts = new Credentials();
            dis = new DataInputStream(in);
            ts.readFields(dis);
            for (Token<? extends TokenIdentifier> token : ts.getAllTokens()) {
                token.setKind(isHttps ? WebHdfsConstants.HSFTP_TOKEN_KIND : WebHdfsConstants.HFTP_TOKEN_KIND);
                SecurityUtil.setTokenService(token, serviceAddr);
            }
            credentials = ts;
        }
        catch (Exception e) {
            try {
                throw new IOException("Unable to obtain remote token", e);
            }
            catch (Throwable throwable) {
                IOUtilsClient.cleanup(LOG, dis);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        IOUtilsClient.cleanup(LOG, dis);
        if (conn != null) {
            conn.disconnect();
        }
        return credentials;
    }

    public static void cancelDelegationToken(URLConnectionFactory factory, URI nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException, AuthenticationException {
        StringBuilder buf = new StringBuilder(nnAddr.toString()).append(CANCEL_DELEGATION_TOKEN_PATH_SPEC).append("?").append(TOKEN).append("=").append(tok.encodeToUrlString());
        HttpURLConnection conn = DelegationUtilsClient.run(factory, new URL(buf.toString()));
        conn.disconnect();
    }

    public static long renewDelegationToken(URLConnectionFactory factory, URI nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException, AuthenticationException {
        long l;
        StringBuilder buf = new StringBuilder(nnAddr.toString()).append(RENEW_DELEGATION_TOKEN_PATH_SPEC).append("?").append(TOKEN).append("=").append(tok.encodeToUrlString());
        HttpURLConnection connection = null;
        BufferedReader in = null;
        try {
            long result;
            connection = DelegationUtilsClient.run(factory, new URL(buf.toString()));
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            l = result = Long.parseLong(in.readLine());
        }
        catch (IOException ie) {
            try {
                LOG.info("error in renew over HTTP", (Throwable)ie);
                IOException e = DelegationUtilsClient.getExceptionFromResponse(connection);
                if (e != null) {
                    LOG.info("rethrowing exception from HTTP request: " + e.getLocalizedMessage());
                    throw e;
                }
                throw ie;
            }
            catch (Throwable throwable) {
                IOUtilsClient.cleanup(LOG, in);
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
        IOUtilsClient.cleanup(LOG, in);
        if (connection != null) {
            connection.disconnect();
        }
        return l;
    }

    private static IOException getExceptionFromResponse(HttpURLConnection con) {
        String resp;
        Throwable e = null;
        if (con == null) {
            return null;
        }
        try {
            resp = con.getResponseMessage();
        }
        catch (IOException ie) {
            return null;
        }
        if (resp == null || resp.isEmpty()) {
            return null;
        }
        String exceptionClass = "";
        String exceptionMsg = "";
        String[] rs = resp.split(";");
        if (rs.length < 2) {
            return null;
        }
        exceptionClass = rs[0];
        exceptionMsg = rs[1];
        LOG.info("Error response from HTTP request=" + resp + ";ec=" + exceptionClass + ";em=" + exceptionMsg);
        if (exceptionClass == null || exceptionClass.isEmpty()) {
            return null;
        }
        try {
            Class<Exception> ec = Class.forName(exceptionClass).asSubclass(Exception.class);
            Constructor<Exception> constructor = ec.getConstructor(String.class);
            e = (IOException)constructor.newInstance(exceptionMsg);
        }
        catch (Exception ee) {
            LOG.warn("failed to create object of this class", (Throwable)ee);
        }
        if (e == null) {
            return null;
        }
        e.setStackTrace(new StackTraceElement[0]);
        LOG.info("Exception from HTTP response=" + e.getLocalizedMessage());
        return e;
    }

    private static HttpURLConnection run(URLConnectionFactory factory, URL url) throws IOException, AuthenticationException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)factory.openConnection(url, true);
            if (conn.getResponseCode() != 200) {
                String msg = conn.getResponseMessage();
                throw new IOException("Error when dealing remote token: " + msg);
            }
        }
        catch (IOException ie) {
            LOG.info("Error when dealing remote token:", (Throwable)ie);
            IOException e = DelegationUtilsClient.getExceptionFromResponse(conn);
            if (e != null) {
                LOG.info("rethrowing exception from HTTP request: " + e.getLocalizedMessage());
                throw e;
            }
            throw ie;
        }
        return conn;
    }

    public static String getDelegationTokenUrlParam(String tokenString) {
        if (tokenString == null) {
            return "";
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            return SET_DELEGATION + tokenString;
        }
        return "";
    }
}

