/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;

@InterfaceAudience.Private
public class BlockInfoContiguous
extends BlockInfo {
    public static final BlockInfoContiguous[] EMPTY_ARRAY = new BlockInfoContiguous[0];

    public BlockInfoContiguous(short size) {
        super(size);
    }

    public BlockInfoContiguous(Block blk, short size) {
        super(blk, size);
    }

    protected BlockInfoContiguous(BlockInfoContiguous from) {
        super(from);
    }

    private int ensureCapacity(int num) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        int last = this.numNodes();
        if (this.triplets.length >= (last + num) * 3) {
            return last;
        }
        Object[] old = this.triplets;
        this.triplets = new Object[(last + num) * 3];
        System.arraycopy(old, 0, this.triplets, 0, last * 3);
        return last;
    }

    @Override
    boolean addStorage(DatanodeStorageInfo storage) {
        int lastNode = this.ensureCapacity(1);
        this.setStorageInfo(lastNode, storage);
        this.setNext(lastNode, null);
        this.setPrevious(lastNode, null);
        return true;
    }

    @Override
    boolean removeStorage(DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return false;
        }
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is still in the list and must be removed first.";
        int lastNode = this.numNodes() - 1;
        this.setStorageInfo(dnIndex, this.getStorageInfo(lastNode));
        this.setNext(dnIndex, this.getNext(lastNode));
        this.setPrevious(dnIndex, this.getPrevious(lastNode));
        this.setStorageInfo(lastNode, null);
        this.setNext(lastNode, null);
        this.setPrevious(lastNode, null);
        return true;
    }

    @Override
    public int numNodes() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
            if (this.getDatanode(idx) == null) continue;
            return idx + 1;
        }
        return 0;
    }
}

