/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;

public class BlockUnderConstructionFeature {
    private HdfsServerConstants.BlockUCState blockUCState;
    private static final ReplicaUnderConstruction[] NO_REPLICAS = new ReplicaUnderConstruction[0];
    private ReplicaUnderConstruction[] replicas = NO_REPLICAS;
    private int primaryNodeIndex = -1;
    private long blockRecoveryId = 0L;
    private Block truncateBlock;

    public BlockUnderConstructionFeature(Block blk, HdfsServerConstants.BlockUCState state, DatanodeStorageInfo[] targets) {
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "BlockUnderConstructionFeature cannot be in COMPLETE state";
        this.blockUCState = state;
        this.setExpectedLocations(blk, targets);
    }

    public void setExpectedLocations(Block block, DatanodeStorageInfo[] targets) {
        int numLocations = targets == null ? 0 : targets.length;
        this.replicas = new ReplicaUnderConstruction[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            this.replicas[i] = new ReplicaUnderConstruction(block, targets[i], HdfsServerConstants.ReplicaState.RBW);
        }
    }

    public DatanodeStorageInfo[] getExpectedStorageLocations() {
        int numLocations = this.getNumExpectedLocations();
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            storages[i] = this.replicas[i].getExpectedStorageLocation();
        }
        return storages;
    }

    public int getNumExpectedLocations() {
        return this.replicas.length;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return this.blockUCState;
    }

    void setBlockUCState(HdfsServerConstants.BlockUCState s) {
        this.blockUCState = s;
    }

    public long getBlockRecoveryId() {
        return this.blockRecoveryId;
    }

    public Block getTruncateBlock() {
        return this.truncateBlock;
    }

    public void setTruncateBlock(Block recoveryBlock) {
        this.truncateBlock = recoveryBlock;
    }

    void commit() {
        this.blockUCState = HdfsServerConstants.BlockUCState.COMMITTED;
    }

    List<ReplicaUnderConstruction> getStaleReplicas(long genStamp) {
        ArrayList<ReplicaUnderConstruction> staleReplicas = new ArrayList<ReplicaUnderConstruction>();
        for (ReplicaUnderConstruction r : this.replicas) {
            if (genStamp == r.getGenerationStamp()) continue;
            staleReplicas.add(r);
        }
        return staleReplicas;
    }

    public void initializeBlockRecovery(BlockInfo blockInfo, long recoveryId) {
        this.setBlockUCState(HdfsServerConstants.BlockUCState.UNDER_RECOVERY);
        this.blockRecoveryId = recoveryId;
        if (this.replicas.length == 0) {
            NameNode.blockStateChangeLog.warn("BLOCK* BlockUnderConstructionFeature.initializeBlockRecovery: No blocks found, lease removed.");
            this.primaryNodeIndex = -1;
            return;
        }
        boolean allLiveReplicasTriedAsPrimary = true;
        for (ReplicaUnderConstruction replica : this.replicas) {
            if (!replica.isAlive()) continue;
            allLiveReplicasTriedAsPrimary = allLiveReplicasTriedAsPrimary && replica.getChosenAsPrimary();
        }
        if (allLiveReplicasTriedAsPrimary) {
            for (ReplicaUnderConstruction replica : this.replicas) {
                replica.setChosenAsPrimary(false);
            }
        }
        long mostRecentLastUpdate = 0L;
        ReplicaUnderConstruction primary = null;
        this.primaryNodeIndex = -1;
        for (int i = 0; i < this.replicas.length; ++i) {
            ReplicaUnderConstruction ruc;
            long lastUpdate;
            if (!this.replicas[i].isAlive() || this.replicas[i].getChosenAsPrimary() || (lastUpdate = (ruc = this.replicas[i]).getExpectedStorageLocation().getDatanodeDescriptor().getLastUpdateMonotonic()) <= mostRecentLastUpdate) continue;
            this.primaryNodeIndex = i;
            primary = ruc;
            mostRecentLastUpdate = lastUpdate;
        }
        if (primary != null) {
            primary.getExpectedStorageLocation().getDatanodeDescriptor().addBlockToBeRecovered(blockInfo);
            primary.setChosenAsPrimary(true);
            NameNode.blockStateChangeLog.debug("BLOCK* {} recovery started, primary={}", (Object)this, (Object)primary);
        }
    }

    void addReplicaIfNotPresent(DatanodeStorageInfo storage, Block reportedBlock, HdfsServerConstants.ReplicaState rState) {
        if (this.replicas.length == 0) {
            this.replicas = new ReplicaUnderConstruction[1];
            this.replicas[0] = new ReplicaUnderConstruction(reportedBlock, storage, rState);
        } else {
            for (int i = 0; i < this.replicas.length; ++i) {
                DatanodeStorageInfo expected = this.replicas[i].getExpectedStorageLocation();
                if (expected == storage) {
                    this.replicas[i].setGenerationStamp(reportedBlock.getGenerationStamp());
                    return;
                }
                if (expected == null || expected.getDatanodeDescriptor() != storage.getDatanodeDescriptor()) continue;
                this.replicas[i] = new ReplicaUnderConstruction(reportedBlock, storage, rState);
                return;
            }
            ReplicaUnderConstruction[] newReplicas = new ReplicaUnderConstruction[this.replicas.length + 1];
            System.arraycopy(this.replicas, 0, newReplicas, 0, this.replicas.length);
            newReplicas[newReplicas.length - 1] = new ReplicaUnderConstruction(reportedBlock, storage, rState);
            this.replicas = newReplicas;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        this.appendUCParts(b);
        return b.toString();
    }

    private void appendUCParts(StringBuilder sb) {
        sb.append("{UCState=").append((Object)this.blockUCState).append(", truncateBlock=").append(this.truncateBlock).append(", primaryNodeIndex=").append(this.primaryNodeIndex).append(", replicas=[");
        int i = 0;
        for (ReplicaUnderConstruction r : this.replicas) {
            r.appendStringTo(sb);
            if (++i >= this.replicas.length) continue;
            sb.append(", ");
        }
        sb.append("]}");
    }

    public void appendUCPartsConcise(StringBuilder sb) {
        sb.append("replicas=");
        int i = 0;
        for (ReplicaUnderConstruction r : this.replicas) {
            sb.append(r.getExpectedStorageLocation().getDatanodeDescriptor());
            if (++i >= this.replicas.length) continue;
            sb.append(", ");
        }
    }
}

