/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.StringUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.Time;
import org.slf4j.Logger;

@InterfaceAudience.Private
class InvalidateBlocks {
    private final Map<DatanodeInfo, LightWeightHashSet<Block>> node2blocks = new HashMap<DatanodeInfo, LightWeightHashSet<Block>>();
    private long numBlocks = 0L;
    private final int blockInvalidateLimit;
    private final long pendingPeriodInMs;
    private final long startupTime = Time.monotonicNow();

    InvalidateBlocks(int blockInvalidateLimit, long pendingPeriodInMs) {
        this.blockInvalidateLimit = blockInvalidateLimit;
        this.pendingPeriodInMs = pendingPeriodInMs;
        this.printBlockDeletionTime(BlockManager.LOG);
    }

    private void printBlockDeletionTime(Logger log) {
        log.info("dfs.namenode.startup.delay.block.deletion.sec is set to " + DFSUtil.durationToString(this.pendingPeriodInMs));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MMM dd HH:mm:ss");
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(13, (int)(this.pendingPeriodInMs / 1000L));
        log.info("The block deletion will start around " + sdf.format(calendar.getTime()));
    }

    synchronized long numBlocks() {
        return this.numBlocks;
    }

    synchronized boolean contains(DatanodeInfo dn, Block block) {
        LightWeightHashSet<Block> s = this.node2blocks.get(dn);
        if (s == null) {
            return false;
        }
        Block blockInSet = s.getElement(block);
        return blockInSet != null && block.getGenerationStamp() == blockInSet.getGenerationStamp();
    }

    synchronized void add(Block block, DatanodeInfo datanode, boolean log) {
        LightWeightHashSet<Block> set = this.node2blocks.get(datanode);
        if (set == null) {
            set = new LightWeightHashSet();
            this.node2blocks.put(datanode, set);
        }
        if (set.add(block)) {
            ++this.numBlocks;
            if (log) {
                NameNode.blockStateChangeLog.debug("BLOCK* {}: add {} to {}", new Object[]{this.getClass().getSimpleName(), block, datanode});
            }
        }
    }

    synchronized void remove(DatanodeInfo dn) {
        LightWeightHashSet<Block> blocks = this.node2blocks.remove(dn);
        if (blocks != null) {
            this.numBlocks -= (long)blocks.size();
        }
    }

    synchronized void remove(DatanodeInfo dn, Block block) {
        LightWeightHashSet<Block> v = this.node2blocks.get(dn);
        if (v != null && v.remove(block)) {
            --this.numBlocks;
            if (v.isEmpty()) {
                this.node2blocks.remove(dn);
            }
        }
    }

    synchronized void dump(PrintWriter out) {
        int size = this.node2blocks.values().size();
        out.println("Metasave: Blocks " + this.numBlocks + " waiting deletion from " + size + " datanodes.");
        if (size == 0) {
            return;
        }
        for (Map.Entry<DatanodeInfo, LightWeightHashSet<Block>> entry : this.node2blocks.entrySet()) {
            LightWeightHashSet<Block> blocks = entry.getValue();
            if (blocks.size() <= 0) continue;
            out.println(entry.getKey());
            out.println(StringUtils.join(',', blocks));
        }
    }

    synchronized List<DatanodeInfo> getDatanodes() {
        return new ArrayList<DatanodeInfo>(this.node2blocks.keySet());
    }

    @VisibleForTesting
    long getInvalidationDelay() {
        return this.pendingPeriodInMs - (Time.monotonicNow() - this.startupTime);
    }

    synchronized List<Block> invalidateWork(DatanodeDescriptor dn) {
        long delay = this.getInvalidationDelay();
        if (delay > 0L) {
            if (BlockManager.LOG.isDebugEnabled()) {
                BlockManager.LOG.debug("Block deletion is delayed during NameNode startup. The deletion will start after " + delay + " ms.");
            }
            return null;
        }
        LightWeightHashSet<Block> set = this.node2blocks.get(dn);
        if (set == null) {
            return null;
        }
        int limit = this.blockInvalidateLimit;
        List<Block> toInvalidate = set.pollN(limit);
        if (set.isEmpty()) {
            this.remove(dn);
        }
        dn.addBlocksToBeInvalidated(toInvalidate);
        this.numBlocks -= (long)toInvalidate.size();
        return toInvalidate;
    }

    synchronized void clear() {
        this.node2blocks.clear();
        this.numBlocks = 0L;
    }
}

