/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.top.window;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindow;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.util.Metrics2Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RollingWindowManager {
    public static final Logger LOG = LoggerFactory.getLogger(RollingWindowManager.class);
    private final int windowLenMs;
    private final int bucketsPerWindow;
    private final int topUsersCnt;
    public ConcurrentHashMap<String, RollingWindowMap> metricMap = new ConcurrentHashMap();

    public RollingWindowManager(Configuration conf, int reportingPeriodMs) {
        this.windowLenMs = reportingPeriodMs;
        this.bucketsPerWindow = conf.getInt("dfs.namenode.top.window.num.buckets", 10);
        Preconditions.checkArgument(this.bucketsPerWindow > 0, "a window should have at least one bucket");
        Preconditions.checkArgument(this.bucketsPerWindow <= this.windowLenMs, "the minimum size of a bucket is 1 ms");
        Preconditions.checkArgument(this.windowLenMs % this.bucketsPerWindow == 0, "window size must be a multiplication of number of buckets");
        this.topUsersCnt = conf.getInt("dfs.namenode.top.num.users", 10);
        Preconditions.checkArgument(this.topUsersCnt > 0, "the number of requested top users must be at least 1");
    }

    public void recordMetric(long time, String command, String user, long delta) {
        RollingWindow window = this.getRollingWindow(command, user);
        window.incAt(time, delta);
    }

    public TopWindow snapshot(long time) {
        TopWindow window = new TopWindow(this.windowLenMs);
        Set metricNames = this.metricMap.keySet();
        LOG.debug("iterating in reported metrics, size={} values={}", (Object)metricNames.size(), (Object)metricNames);
        for (Map.Entry<String, RollingWindowMap> entry : this.metricMap.entrySet()) {
            int i;
            RollingWindowMap rollingWindows;
            String metricName = entry.getKey();
            Metrics2Util.TopN topN = this.getTopUsersForMetric(time, metricName, rollingWindows = entry.getValue());
            int size = topN.size();
            if (size == 0) continue;
            Op op = new Op(metricName, topN.getTotal());
            window.addOp(op);
            Stack reverse = new Stack();
            for (i = 0; i < size; ++i) {
                reverse.push(topN.poll());
            }
            for (i = 0; i < size; ++i) {
                Metrics2Util.NameValuePair userEntry = (Metrics2Util.NameValuePair)reverse.pop();
                User user = new User(userEntry.getName(), userEntry.getValue());
                op.addUser(user);
            }
        }
        return window;
    }

    private Metrics2Util.TopN getTopUsersForMetric(long time, String metricName, RollingWindowMap rollingWindows) {
        Metrics2Util.TopN topN = new Metrics2Util.TopN(this.topUsersCnt);
        Iterator iterator = rollingWindows.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String userName = (String)entry.getKey();
            RollingWindow aWindow = (RollingWindow)entry.getValue();
            long windowSum = aWindow.getSum(time);
            if (windowSum == 0L) {
                LOG.debug("gc window of metric: {} userName: {}", (Object)metricName, (Object)userName);
                iterator.remove();
                continue;
            }
            LOG.debug("offer window of metric: {} userName: {} sum: {}", new Object[]{metricName, userName, windowSum});
            topN.offer(new Metrics2Util.NameValuePair(userName, windowSum));
        }
        LOG.debug("topN users size for command {} is: {}", (Object)metricName, (Object)topN.size());
        return topN;
    }

    private RollingWindow getRollingWindow(String metric, String user) {
        RollingWindow window;
        RollingWindowMap prevRwMap;
        RollingWindowMap rwMap = this.metricMap.get(metric);
        if (rwMap == null && (prevRwMap = this.metricMap.putIfAbsent(metric, rwMap = new RollingWindowMap())) != null) {
            rwMap = prevRwMap;
        }
        if ((window = (RollingWindow)rwMap.get(user)) != null) {
            return window;
        }
        window = new RollingWindow(this.windowLenMs, this.bucketsPerWindow);
        RollingWindow prevWindow = rwMap.putIfAbsent(user, window);
        if (prevWindow != null) {
            window = prevWindow;
        }
        return window;
    }

    public static class User {
        private final String user;
        private final long count;

        public User(String user, long count) {
            this.user = user;
            this.count = count;
        }

        public String getUser() {
            return this.user;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class Op {
        private final String opType;
        private final List<User> topUsers;
        private final long totalCount;

        public Op(String opType, long totalCount) {
            this.opType = opType;
            this.topUsers = Lists.newArrayList();
            this.totalCount = totalCount;
        }

        public void addUser(User u) {
            this.topUsers.add(u);
        }

        public String getOpType() {
            return this.opType;
        }

        public List<User> getTopUsers() {
            return this.topUsers;
        }

        public long getTotalCount() {
            return this.totalCount;
        }
    }

    public static class TopWindow {
        private final int windowMillis;
        private final List<Op> top;

        public TopWindow(int windowMillis) {
            this.windowMillis = windowMillis;
            this.top = Lists.newArrayList();
        }

        public void addOp(Op op) {
            this.top.add(op);
        }

        public int getWindowLenMs() {
            return this.windowMillis;
        }

        public List<Op> getOps() {
            return this.top;
        }
    }

    private static class RollingWindowMap
    extends ConcurrentHashMap<String, RollingWindow> {
        private static final long serialVersionUID = -6785807073237052051L;

        private RollingWindowMap() {
        }
    }
}

