/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;

public class Diff<K, E extends Element<K>> {
    private static final int DEFAULT_ARRAY_INITIAL_CAPACITY = 4;
    private List<E> created;
    private List<E> deleted;

    protected static <K, E extends Comparable<K>> int search(List<E> elements, K name) {
        return elements == null ? -1 : Collections.binarySearch(elements, name);
    }

    private static <E> void remove(List<E> elements, int i, E expected) {
        E removed = elements.remove(-i - 1);
        Preconditions.checkState(removed == expected, "removed != expected=%s, removed=%s.", expected, removed);
    }

    protected Diff() {
    }

    protected Diff(List<E> created, List<E> deleted) {
        this.created = created;
        this.deleted = deleted;
    }

    public List<E> getList(ListType type) {
        List<E> list = type == ListType.CREATED ? this.created : this.deleted;
        return list == null ? Collections.emptyList() : list;
    }

    public int searchIndex(ListType type, K name) {
        return Diff.search(this.getList(type), name);
    }

    public E search(ListType type, K name) {
        List<E> list = this.getList(type);
        int c = Diff.search(list, name);
        return (E)(c < 0 ? null : (Element)list.get(c));
    }

    public boolean isEmpty() {
        return !(this.created != null && !this.created.isEmpty() || this.deleted != null && !this.deleted.isEmpty());
    }

    private void insert(ListType type, E element, int i) {
        List<E> list;
        List<E> list2 = list = type == ListType.CREATED ? this.created : this.deleted;
        if (i >= 0) {
            throw new AssertionError((Object)("Element already exists: element=" + element + ", " + (Object)((Object)type) + "=" + list));
        }
        if (list == null) {
            list = new ArrayList(4);
            if (type == ListType.CREATED) {
                this.created = list;
            } else if (type == ListType.DELETED) {
                this.deleted = list;
            }
        }
        list.add(-i - 1, element);
    }

    public int create(E element) {
        int c = Diff.search(this.created, element.getKey());
        this.insert(ListType.CREATED, element, c);
        return c;
    }

    public void undoCreate(E element, int insertionPoint) {
        Diff.remove(this.created, insertionPoint, element);
    }

    public UndoInfo<E> delete(E element) {
        int c = Diff.search(this.created, element.getKey());
        Element previous = null;
        Integer d = null;
        if (c >= 0) {
            previous = (Element)this.created.remove(c);
        } else {
            d = Diff.search(this.deleted, element.getKey());
            this.insert(ListType.DELETED, element, d);
        }
        return new UndoInfo(c, previous, d);
    }

    public void undoDelete(E element, UndoInfo<E> undoInfo) {
        int c = ((UndoInfo)undoInfo).createdInsertionPoint;
        if (c >= 0) {
            this.created.add(c, ((UndoInfo)undoInfo).trashed);
        } else {
            Diff.remove(this.deleted, ((UndoInfo)undoInfo).deletedInsertionPoint, element);
        }
    }

    public UndoInfo<E> modify(E oldElement, E newElement) {
        Preconditions.checkArgument(oldElement != newElement, "They are the same object: oldElement == newElement = %s", newElement);
        Preconditions.checkArgument(oldElement.compareTo(newElement.getKey()) == 0, "The names do not match: oldElement=%s, newElement=%s", oldElement, newElement);
        int c = Diff.search(this.created, newElement.getKey());
        Element<Object> previous = null;
        Integer d = null;
        if (c >= 0) {
            previous = (Element)this.created.set(c, newElement);
            previous = oldElement;
        } else {
            d = Diff.search(this.deleted, oldElement.getKey());
            if (d < 0) {
                this.insert(ListType.CREATED, newElement, c);
                this.insert(ListType.DELETED, oldElement, d);
            }
        }
        return new UndoInfo(c, previous, d);
    }

    public void undoModify(E oldElement, E newElement, UndoInfo<E> undoInfo) {
        int c = ((UndoInfo)undoInfo).createdInsertionPoint;
        if (c >= 0) {
            this.created.set(c, ((UndoInfo)undoInfo).trashed);
        } else {
            int d = ((UndoInfo)undoInfo).deletedInsertionPoint;
            if (d < 0) {
                Diff.remove(this.created, c, newElement);
                Diff.remove(this.deleted, d, oldElement);
            }
        }
    }

    public Container<E> accessPrevious(K name) {
        return Diff.accessPrevious(name, this.created, this.deleted);
    }

    private static <K, E extends Element<K>> Container<E> accessPrevious(K name, List<E> clist, List<E> dlist) {
        int d = Diff.search(dlist, name);
        if (d >= 0) {
            return new Container(dlist.get(d));
        }
        int c = Diff.search(clist, name);
        return c < 0 ? null : new Container(null);
    }

    public Container<E> accessCurrent(K name) {
        return Diff.accessPrevious(name, this.deleted, this.created);
    }

    public List<E> apply2Previous(List<E> previous) {
        return Diff.apply2Previous(previous, this.getList(ListType.CREATED), this.getList(ListType.DELETED));
    }

    private static <K, E extends Element<K>> List<E> apply2Previous(List<E> previous, List<E> clist, List<E> dlist) {
        Element c;
        ArrayList<Element<Object>> tmp = new ArrayList<Element<Object>>(previous.size() - dlist.size());
        Iterator<E> i = previous.iterator();
        for (Element deleted : dlist) {
            Element e = (Element)i.next();
            int cmp = 0;
            while ((cmp = e.compareTo(deleted.getKey())) < 0) {
                tmp.add(e);
                e = (Element)i.next();
            }
            Preconditions.checkState(cmp == 0);
        }
        while (i.hasNext()) {
            tmp.add((Element<Object>)i.next());
        }
        ArrayList<Element> current = new ArrayList<Element>(tmp.size() + clist.size());
        Iterator tmpIterator = tmp.iterator();
        Iterator<E> cIterator = clist.iterator();
        Element t = tmpIterator.hasNext() ? (Element)tmpIterator.next() : null;
        Element element = c = cIterator.hasNext() ? (Element)cIterator.next() : null;
        while (t != null || c != null) {
            int cmp;
            int n = c == null ? 1 : (cmp = t == null ? -1 : c.compareTo(t.getKey()));
            if (cmp < 0) {
                current.add(c);
                c = cIterator.hasNext() ? (Element)cIterator.next() : null;
                continue;
            }
            if (cmp > 0) {
                current.add(t);
                t = tmpIterator.hasNext() ? (Element)tmpIterator.next() : null;
                continue;
            }
            throw new AssertionError((Object)"Violated assumption (A3).");
        }
        return current;
    }

    public List<E> apply2Current(List<E> current) {
        return Diff.apply2Previous(current, this.getList(ListType.DELETED), this.getList(ListType.CREATED));
    }

    public void combinePosterior(Diff<K, E> posterior, Processor<E> deletedProcesser) {
        Element d;
        Iterator<E> createdIterator = posterior.getList(ListType.CREATED).iterator();
        Iterator<E> deletedIterator = posterior.getList(ListType.DELETED).iterator();
        Element c = createdIterator.hasNext() ? (Element)createdIterator.next() : null;
        Element element = d = deletedIterator.hasNext() ? (Element)deletedIterator.next() : null;
        while (c != null || d != null) {
            UndoInfo<Element> ui;
            int cmp;
            int n = c == null ? 1 : (cmp = d == null ? -1 : c.compareTo(d.getKey()));
            if (cmp < 0) {
                this.create(c);
                c = createdIterator.hasNext() ? (Element)createdIterator.next() : null;
                continue;
            }
            if (cmp > 0) {
                ui = this.delete(d);
                if (deletedProcesser != null) {
                    deletedProcesser.process(((UndoInfo)ui).trashed);
                }
                d = deletedIterator.hasNext() ? (Element)deletedIterator.next() : null;
                continue;
            }
            ui = this.modify(d, c);
            if (deletedProcesser != null) {
                deletedProcesser.process(((UndoInfo)ui).trashed);
            }
            c = createdIterator.hasNext() ? (Element)createdIterator.next() : null;
            d = deletedIterator.hasNext() ? (Element)deletedIterator.next() : null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{created=" + this.getList(ListType.CREATED) + ", deleted=" + this.getList(ListType.DELETED) + "}";
    }

    public static class UndoInfo<E> {
        private final int createdInsertionPoint;
        private final E trashed;
        private final Integer deletedInsertionPoint;

        private UndoInfo(int createdInsertionPoint, E trashed, Integer deletedInsertionPoint) {
            this.createdInsertionPoint = createdInsertionPoint;
            this.trashed = trashed;
            this.deletedInsertionPoint = deletedInsertionPoint;
        }

        public E getTrashedElement() {
            return this.trashed;
        }
    }

    public static class Container<E> {
        private final E element;

        private Container(E element) {
            this.element = element;
        }

        public E getElement() {
            return this.element;
        }
    }

    public static interface Processor<E> {
        public void process(E var1);
    }

    public static interface Element<K>
    extends Comparable<K> {
        public K getKey();
    }

    public static enum ListType {
        CREATED,
        DELETED;

    }
}

