/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CompressedWritable
implements Writable {
    private byte[] compressed;

    @Override
    public final void readFields(DataInput in) throws IOException {
        this.compressed = new byte[in.readInt()];
        in.readFully(this.compressed, 0, this.compressed.length);
    }

    protected void ensureInflated() {
        if (this.compressed != null) {
            try {
                ByteArrayInputStream deflated = new ByteArrayInputStream(this.compressed);
                DataInputStream inflater = new DataInputStream(new InflaterInputStream(deflated));
                this.readFieldsCompressed(inflater);
                this.compressed = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract void readFieldsCompressed(DataInput var1) throws IOException;

    @Override
    public final void write(DataOutput out) throws IOException {
        if (this.compressed == null) {
            ByteArrayOutputStream deflated = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(1);
            DataOutputStream dout = new DataOutputStream(new DeflaterOutputStream((OutputStream)deflated, deflater));
            this.writeCompressed(dout);
            dout.close();
            deflater.end();
            this.compressed = deflated.toByteArray();
        }
        out.writeInt(this.compressed.length);
        out.write(this.compressed);
    }

    protected abstract void writeCompressed(DataOutput var1) throws IOException;
}

