/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io;

import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class DataInputByteBuffer
extends DataInputStream {
    private Buffer buffers;

    public DataInputByteBuffer() {
        this(new Buffer());
    }

    private DataInputByteBuffer(Buffer buffers) {
        super(buffers);
        this.buffers = buffers;
    }

    public void reset(ByteBuffer ... input) {
        this.buffers.reset(input);
    }

    public ByteBuffer[] getData() {
        return this.buffers.getData();
    }

    public int getPosition() {
        return this.buffers.getPosition();
    }

    public int getLength() {
        return this.buffers.getLength();
    }

    private static class Buffer
    extends InputStream {
        private final byte[] scratch = new byte[1];
        ByteBuffer[] buffers = new ByteBuffer[0];
        int bidx;
        int pos;
        int length;

        private Buffer() {
        }

        @Override
        public int read() {
            if (-1 == this.read(this.scratch, 0, 1)) {
                return -1;
            }
            return this.scratch[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            int rem;
            if (this.bidx >= this.buffers.length) {
                return -1;
            }
            int cur = 0;
            do {
                rem = Math.min(len, this.buffers[this.bidx].remaining());
                this.buffers[this.bidx].get(b, off, rem);
                cur += rem;
                off += rem;
            } while ((len -= rem) > 0 && ++this.bidx < this.buffers.length);
            this.pos += cur;
            return cur;
        }

        public void reset(ByteBuffer[] buffers) {
            this.length = 0;
            this.pos = 0;
            this.bidx = 0;
            this.buffers = buffers;
            for (ByteBuffer b : buffers) {
                this.length += b.remaining();
            }
        }

        public int getPosition() {
            return this.pos;
        }

        public int getLength() {
            return this.length;
        }

        public ByteBuffer[] getData() {
            return this.buffers;
        }
    }
}

